/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import java.util.Arrays;
import java.util.List;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.metadata.json.api.handler.ArrayHandler;
import org.mule.metadata.json.api.handler.BooleanHandler;
import org.mule.metadata.json.api.handler.CombinedHandler;
import org.mule.metadata.json.api.handler.EmptyHandler;
import org.mule.metadata.json.api.handler.EnumHandler;
import org.mule.metadata.json.api.handler.NullHandler;
import org.mule.metadata.json.api.handler.NumberHandler;
import org.mule.metadata.json.api.handler.ObjectHandler;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.ReferenceHandler;
import org.mule.metadata.json.api.handler.SchemaHandler;
import org.mule.metadata.json.api.handler.StringHandler;

public class HandlerManager {
    private List<? extends SchemaHandler> handlers = Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(), new EnumHandler(), new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(), new StringHandler());

    public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
        if (parsingContext.isAlreadyBuild(schema)) {
            return parsingContext.getBuilder(schema).get();
        }
        for (SchemaHandler schemaHandler : this.handlers) {
            if (!schemaHandler.handles(schema)) continue;
            return schemaHandler.handle(schema, BaseTypeBuilder.create(JsonTypeLoader.JSON), this, parsingContext);
        }
        return BaseTypeBuilder.create(JsonTypeLoader.JSON).anyType();
    }
}

