/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.service;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.config.internal.context.service.InjectParamsFromContextServiceUtils;
import org.mule.runtime.module.service.internal.manager.DefaultMethodInvoker;

public class InjectParamsFromContextServiceMethodInvoker
extends DefaultMethodInvoker {
    public static final String NO_OBJECT_FOUND_FOR_PARAM = "No object found in the registry for parameter '%s' of method '%s' in service '%s'";
    private final LoadingCache<Pair<Object, Method>, Method> injectableMethodCache;
    private final LoadingCache<Class<?>, Collection<?>> lookupAllByTypeCache;
    private final LoadingCache<String, Optional<?>> lookupByNameCache;

    public InjectParamsFromContextServiceMethodInvoker(Registry registry) {
        Objects.requireNonNull(registry, "registry cannot be null");
        this.lookupAllByTypeCache = Caffeine.newBuilder().build(registry::lookupAllByType);
        this.lookupByNameCache = Caffeine.newBuilder().build(registry::lookupByName);
        this.injectableMethodCache = Caffeine.newBuilder().build(p -> this.resolveInjectableMethod(p.getFirst(), (Method)p.getSecond()));
    }

    @Override
    public Object invoke(Object target, Method method, Object[] args) throws Throwable {
        List<Object> augmentedArgs;
        Method injectable = (Method)this.injectableMethodCache.get(new Pair<Object, Method>(target, method));
        if (injectable == method) {
            return super.invoke(target, method, args);
        }
        try {
            augmentedArgs = this.calculateAugmentedArgs(target, method, args, injectable);
        }
        catch (NullPointerException e) {
            return super.invoke(target, method, args);
        }
        return super.invoke(target, injectable, augmentedArgs.toArray());
    }

    private List<Object> calculateAugmentedArgs(Object target, Method method, Object[] args, Method injectable) {
        ArrayList<Object> augmentedArgs = args == null ? new ArrayList<Object>() : new ArrayList<Object>(Arrays.asList(args));
        for (int i = method.getParameters().length; i < injectable.getParameters().length; ++i) {
            Parameter parameter = injectable.getParameters()[i];
            augmentedArgs.add(InjectParamsFromContextServiceUtils.calculateAugmentedArgForParamerter(parameter, this.lookupByNameCache, this.lookupAllByTypeCache, injectable, target.toString()));
        }
        return augmentedArgs;
    }

    private Method resolveInjectableMethod(Object target, Method method) {
        Method candidate = null;
        for (Method serviceImplMethod : this.getImplementationDeclaredMethods(target)) {
            candidate = InjectParamsFromContextServiceUtils.resolveInjectableMethodFor(method, serviceImplMethod, this.lookupAllByTypeCache, candidate, target.toString());
        }
        return candidate != null ? candidate : method;
    }

    private Method[] getImplementationDeclaredMethods(Object target) {
        LinkedList<Method> methods = new LinkedList<Method>();
        for (Class<?> clazz = target.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            methods.addAll(Arrays.asList(clazz.getDeclaredMethods()));
        }
        return methods.toArray(new Method[methods.size()]);
    }
}

