/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.config;

import java.util.Optional;
import java.util.function.Consumer;
import org.mule.runtime.api.config.custom.CustomizationService;

public class CustomService<T> {
    private final String serviceId;
    private final Class<T> serviceClass;
    private final boolean baseContext;
    private final Consumer<CustomizationService.ServiceInterceptor<T>> serviceImplInterceptorConsumer;

    public CustomService(String serviceId, Class<T> serviceClass, boolean baseContext) {
        this.serviceId = serviceId;
        this.serviceClass = serviceClass;
        this.serviceImplInterceptorConsumer = null;
        this.baseContext = baseContext;
    }

    public CustomService(String serviceId, Consumer<CustomizationService.ServiceInterceptor<T>> serviceImplInterceptorConsumer, boolean baseContext) {
        this.serviceId = serviceId;
        this.serviceImplInterceptorConsumer = serviceImplInterceptorConsumer;
        this.serviceClass = null;
        this.baseContext = baseContext;
    }

    public Optional<Class<T>> getServiceClass() {
        return Optional.ofNullable(this.serviceClass);
    }

    public Optional<T> getServiceImpl() {
        return this.getServiceImpl(null);
    }

    public Optional<T> getServiceImpl(T defaultService) {
        if (this.serviceImplInterceptorConsumer == null) {
            return Optional.empty();
        }
        DefaultServiceInterceptor<T> serviceInterceptor = new DefaultServiceInterceptor<T>(this.serviceId, defaultService);
        this.serviceImplInterceptorConsumer.accept(serviceInterceptor);
        return serviceInterceptor.isRemove() ? Optional.empty() : Optional.ofNullable(serviceInterceptor.getNewServiceImpl());
    }

    public boolean isBaseContext() {
        return this.baseContext;
    }

    private static class DefaultServiceInterceptor<T>
    implements CustomizationService.ServiceInterceptor<T> {
        private final String serviceId;
        private final T serviceImpl;
        private T newServiceImpl;
        private boolean remove;

        public DefaultServiceInterceptor(String serviceId, T serviceImpl) {
            this.serviceId = serviceId;
            this.serviceImpl = serviceImpl;
        }

        @Override
        public Optional<T> getDefaultServiceImpl() {
            return Optional.ofNullable(this.serviceImpl);
        }

        @Override
        public void overrideServiceImpl(T newServiceImpl) {
            this.newServiceImpl = newServiceImpl;
        }

        @Override
        public void remove() {
            if (this.newServiceImpl != null) {
                throw new IllegalStateException(String.format("A 'newServiceImpl' is already present '%s' for service '%s' with default '%s'", this.newServiceImpl, this.serviceId, this.serviceImpl));
            }
            this.remove = true;
        }

        public T getNewServiceImpl() {
            if (this.remove) {
                throw new IllegalStateException(String.format("Service '%s' with default '%s' set to be removed, can't be overridden", this.serviceId, this.serviceImpl));
            }
            return this.newServiceImpl;
        }

        public boolean isRemove() {
            return this.remove;
        }
    }
}

