/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.connection.PoolingListener;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.core.api.connection.util.ConnectionProviderUtils;
import org.mule.runtime.core.api.lifecycle.LifecycleState;
import org.mule.runtime.core.internal.connection.CachedConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.NullConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.PoolingConnectionManagementStrategy;
import org.mule.runtime.core.internal.connection.XAConnectionManagementStrategyFactory;
import org.mule.runtime.core.internal.connection.adapter.XATransactionalConnectionProvider;
import org.mule.sdk.api.connectivity.TransactionalConnection;

final class ConnectionManagementStrategyFactory {
    private final PoolingProfile defaultPoolingProfile;
    private final LifecycleState deploymentLifecycleState;
    private final Optional<XAConnectionManagementStrategyFactory> xaConnectionManagementStrategyFactory;

    ConnectionManagementStrategyFactory(PoolingProfile defaultPoolingProfile, LifecycleState deploymentLifecycleState, Optional<XAConnectionManagementStrategyFactory> xaConnectionManagementStrategyFactory) {
        this.defaultPoolingProfile = defaultPoolingProfile;
        this.deploymentLifecycleState = deploymentLifecycleState;
        this.xaConnectionManagementStrategyFactory = xaConnectionManagementStrategyFactory;
    }

    public <C> ConnectionManagementStrategy<C> getStrategy(ConnectionProvider<C> connectionProvider, FeatureFlaggingService featureFlaggingService) {
        ConnectionManagementType managementType = this.getManagementType(connectionProvider);
        ConnectionManagementStrategy<C> managementStrategy = null;
        if (managementType == ConnectionManagementType.POOLING) {
            managementStrategy = this.pooling(connectionProvider, featureFlaggingService);
        }
        if (this.supportsXa(connectionProvider)) {
            XATransactionalConnectionProvider xaTxConnectionProvider = (XATransactionalConnectionProvider)ConnectionProviderUtils.unwrapProviderWrapper(connectionProvider, XATransactionalConnectionProvider.class);
            return this.handleForXa(connectionProvider, managementType, managementStrategy, xaTxConnectionProvider);
        }
        if (managementStrategy != null) {
            return managementStrategy;
        }
        if (managementType == ConnectionManagementType.CACHED) {
            return this.cached(connectionProvider);
        }
        if (managementType == ConnectionManagementType.NONE) {
            return this.withoutManagement(connectionProvider);
        }
        throw new IllegalArgumentException("Unknown management type: " + String.valueOf((Object)managementType));
    }

    private <C extends TransactionalConnection> ConnectionManagementStrategy<C> handleForXa(ConnectionProvider<C> connectionProvider, ConnectionManagementType managementType, ConnectionManagementStrategy<C> poolingManagementStrategy, XATransactionalConnectionProvider<C> xaTXConnProvider) {
        if (poolingManagementStrategy != null) {
            return this.xaConnectionManagementStrategyFactory.map(f -> f.managePooledForXa(poolingManagementStrategy, connectionProvider)).orElse(poolingManagementStrategy);
        }
        if (xaTXConnProvider.getXaPoolingProfile().isDisabled()) {
            return this.xaConnectionManagementStrategyFactory.map(f -> f.managePooledForXa(this.withoutManagement(connectionProvider), connectionProvider)).orElse(this.withoutManagement(connectionProvider));
        }
        return this.xaConnectionManagementStrategyFactory.map(f -> f.manageForXa(this.withoutManagement(connectionProvider), xaTXConnProvider.getXaPoolingProfile(), connectionProvider)).orElseGet(() -> this.getNonPoolingStrategy(connectionProvider, managementType));
    }

    private <C> ConnectionManagementStrategy<C> getNonPoolingStrategy(ConnectionProvider<C> connectionProvider, ConnectionManagementType managementType) {
        if (managementType == ConnectionManagementType.CACHED) {
            return this.cached(connectionProvider);
        }
        if (managementType == ConnectionManagementType.NONE) {
            return this.withoutManagement(connectionProvider);
        }
        throw new IllegalArgumentException("Unknown management type: " + String.valueOf((Object)managementType));
    }

    private <C> ConnectionManagementStrategy<C> cached(ConnectionProvider<C> connectionProvider) {
        return new CachedConnectionManagementStrategy<C>(connectionProvider, this.deploymentLifecycleState);
    }

    private <C> ConnectionManagementStrategy<C> withoutManagement(ConnectionProvider<C> connectionProvider) {
        return new NullConnectionManagementStrategy<C>(connectionProvider);
    }

    private <C> ConnectionManagementStrategy<C> pooling(ConnectionProvider<C> connectionProvider, FeatureFlaggingService featureFlaggingService) {
        PoolingProfile poolingProfile = this.defaultPoolingProfile;
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            ConnectionProviderWrapper cpWrapper = (ConnectionProviderWrapper)connectionProvider;
            poolingProfile = cpWrapper.getPoolingProfile().orElse(poolingProfile);
        }
        return this.pooling(poolingProfile, connectionProvider, (PoolingListener)((Object)ConnectionProviderUtils.unwrapProviderWrapper(connectionProvider, PoolingConnectionProvider.class)), featureFlaggingService);
    }

    private <C> ConnectionManagementStrategy<C> pooling(PoolingProfile poolingProfile, ConnectionProvider<C> connectionProvider, PoolingListener<C> poolingListener, FeatureFlaggingService featureFlaggingService) {
        String ownerConfigName = "";
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            ConnectionProviderWrapper cpWrapper = (ConnectionProviderWrapper)connectionProvider;
            ownerConfigName = cpWrapper.getOwnerConfigName().orElse(ownerConfigName);
        }
        return poolingProfile.isDisabled() ? this.withoutManagement(connectionProvider) : new PoolingConnectionManagementStrategy<C>(connectionProvider, poolingProfile, poolingListener, ownerConfigName, featureFlaggingService);
    }

    private <C> ConnectionManagementType getManagementType(ConnectionProvider<C> connectionProvider) {
        ConnectionManagementType type = ConnectionManagementType.NONE;
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            ConnectionProviderWrapper cpWrapper = (ConnectionProviderWrapper)connectionProvider;
            return cpWrapper.getConnectionManagementType();
        }
        if (connectionProvider instanceof PoolingConnectionProvider) {
            type = ConnectionManagementType.POOLING;
        } else if (connectionProvider instanceof CachedConnectionProvider) {
            type = ConnectionManagementType.CACHED;
        }
        return type;
    }

    private <C> boolean supportsXa(ConnectionProvider<C> connectionProvider) {
        if (connectionProvider instanceof ConnectionProviderWrapper) {
            ConnectionProviderWrapper cpWrapper = (ConnectionProviderWrapper)connectionProvider;
            return cpWrapper.supportsXa();
        }
        return connectionProvider instanceof XATransactionalConnectionProvider;
    }
}

