/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.el.TypeBindings;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.el.BindingContextUtils;
import org.mule.runtime.api.el.CompiledExpression;
import org.mule.runtime.api.el.DefaultValidationResult;
import org.mule.runtime.api.el.ExpressionCompilationException;
import org.mule.runtime.api.el.ExpressionExecutionException;
import org.mule.runtime.api.el.ValidationResult;
import org.mule.runtime.api.el.validation.ConstraintViolation;
import org.mule.runtime.api.el.validation.ScopePhaseValidationMessages;
import org.mule.runtime.api.el.validation.ValidationPhase;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.StreamingUtils;
import org.mule.runtime.core.internal.el.DefaultExpressionManagerSession;
import org.mule.runtime.core.internal.el.ExpressionLanguageSessionAdaptor;
import org.mule.runtime.core.internal.el.ExtendedExpressionLanguageAdaptor;
import org.mule.runtime.core.internal.el.TemplateParser;
import org.mule.runtime.core.internal.transformer.TransformersRegistry;
import org.mule.runtime.core.internal.util.log.OneTimeWarning;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpressionManager
implements ExtendedExpressionManager,
Initialisable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExpressionManager.class);
    private final OneTimeWarning parseWarning = new OneTimeWarning(LOGGER, "Expression parsing is deprecated, regular expressions should be used instead.");
    private MuleContext muleContext;
    private TransformersRegistry transformersRegistry;
    private ExtendedExpressionLanguageAdaptor expressionLanguage;
    private final TemplateParser parser = TemplateParser.createMuleStyleParser();

    @Override
    public void addGlobalBindings(BindingContext bindingContext) {
        this.expressionLanguage.addGlobalBindings(bindingContext);
    }

    @Override
    public TypedValue<?> evaluate(String expression) {
        return this.evaluate(expression, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue<?> evaluate(String expression, CoreEvent event) {
        return this.evaluate(expression, event, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue<?> evaluate(String expression, BindingContext context) {
        return this.evaluate(expression, null, null, null, context);
    }

    @Override
    public TypedValue<?> evaluate(String expression, CoreEvent event, BindingContext context) {
        return this.evaluate(expression, event, CoreEvent.builder(event), null, context);
    }

    @Override
    public TypedValue<?> evaluate(String expression, CoreEvent event, ComponentLocation componentLocation) {
        return this.evaluate(expression, event, CoreEvent.builder(event), componentLocation, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue<?> evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation) {
        return this.evaluate(expression, event, eventBuilder, componentLocation, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue<?> evaluate(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext context) {
        return this.evaluate(expression, event, CoreEvent.builder(event), componentLocation, context);
    }

    private TypedValue<?> evaluate(String expression, CoreEvent event, CoreEvent.Builder eventBuilder, ComponentLocation componentLocation, BindingContext context) {
        return StreamingUtils.updateTypedValueForStreaming(this.expressionLanguage.evaluate(expression, event, eventBuilder, componentLocation, context), event, this.getStreamingManager());
    }

    @Override
    public TypedValue<?> evaluate(String expression, DataType outputType) {
        return this.evaluate(expression, outputType, BindingContextUtils.NULL_BINDING_CONTEXT);
    }

    @Override
    public TypedValue<?> evaluate(String expression, DataType outputType, BindingContext context) {
        return this.evaluate(expression, outputType, context, null);
    }

    @Override
    public TypedValue<?> evaluateLogExpression(String expression, BindingContext context) throws ExpressionExecutionException {
        return this.expressionLanguage.evaluateLogExpression(expression, null, null, context);
    }

    @Override
    public TypedValue<?> evaluate(String expression, DataType outputType, BindingContext context, CoreEvent event) {
        return this.evaluate(expression, outputType, context, event, null, false);
    }

    @Override
    public TypedValue<?> evaluate(String expression, DataType outputType, BindingContext context, CoreEvent event, ComponentLocation componentLocation, boolean failOnNull) throws ExpressionRuntimeException {
        return StreamingUtils.updateTypedValueForStreaming(this.expressionLanguage.evaluate(expression, outputType, event, componentLocation, context, failOnNull), event, this.getStreamingManager());
    }

    private TypedValue<?> transform(TypedValue<?> target, DataType sourceType, DataType outputType) throws TransformerException {
        if (target.getValue() != null && !ClassUtils.isInstance(outputType.getType(), target.getValue())) {
            Object result = this.transformersRegistry.lookupTransformer(sourceType, outputType).transform(target);
            return new TypedValue<Object>(result, outputType);
        }
        return target;
    }

    @Override
    public CompiledExpression compile(String expression, BindingContext context) throws ExpressionCompilationException {
        return this.expressionLanguage.compile(expression, context);
    }

    @Override
    public boolean evaluateBoolean(String expression, CoreEvent event, ComponentLocation componentLocation) throws ExpressionRuntimeException {
        return this.evaluateBoolean(expression, event, componentLocation, false, false);
    }

    @Override
    public boolean evaluateBoolean(String expression, CoreEvent event, ComponentLocation componentLocation, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        return DefaultExpressionManager.resolveBoolean(this.evaluate(expression, DataType.BOOLEAN, BindingContextUtils.NULL_BINDING_CONTEXT, event, componentLocation, false).getValue(), nullReturnsTrue, nonBooleanReturnsTrue, expression);
    }

    @Override
    public boolean evaluateBoolean(String expression, BindingContext bindingCtx, ComponentLocation componentLocation, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue) throws ExpressionRuntimeException {
        return DefaultExpressionManager.resolveBoolean(this.evaluate(expression, DataType.BOOLEAN, bindingCtx).getValue(), nullReturnsTrue, nonBooleanReturnsTrue, expression);
    }

    @Override
    public ScopePhaseValidationMessages collectScopePhaseValidationMessages(String script, String nameIdentifier, TypeBindings bindings) {
        return this.expressionLanguage.collectScopePhaseValidationMessages(script, nameIdentifier, bindings);
    }

    protected static boolean resolveBoolean(Object result, boolean nullReturnsTrue, boolean nonBooleanReturnsTrue, String expression) {
        if (result == null) {
            return nullReturnsTrue;
        }
        Object value = result;
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            if (value.toString().toLowerCase().equalsIgnoreCase("false")) {
                return false;
            }
            if (result.toString().toLowerCase().equalsIgnoreCase("true")) {
                return true;
            }
            return nonBooleanReturnsTrue;
        }
        LOGGER.warn("Expression: " + expression + ", returned an non-boolean result. Returning: " + nonBooleanReturnsTrue);
        return nonBooleanReturnsTrue;
    }

    @Override
    public String parse(String expression, CoreEvent event, ComponentLocation componentLocation) throws ExpressionRuntimeException {
        CoreEvent.Builder eventBuilder = CoreEvent.builder(event);
        if (this.isExpression(expression)) {
            TypedValue<?> evaluation = this.evaluate(expression, event, eventBuilder, componentLocation);
            try {
                return (String)this.transform(evaluation, evaluation.getDataType(), DataType.STRING).getValue();
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to transform %s to %s.", evaluation.getDataType(), DataType.STRING)), (Throwable)e);
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("No expression marker found in expression '%s'. Parsing as plain String.", expression));
        }
        return expression;
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.expressionLanguage.split(expression, event, componentLocation, bindingContext);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, CoreEvent event, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.expressionLanguage.split(expression, event, bindingContext);
    }

    @Override
    public String parseLogTemplate(String template, CoreEvent event, ComponentLocation componentLocation, BindingContext bindingContext) throws ExpressionRuntimeException {
        return this.parser.parse(token -> {
            TypedValue<?> evaluation = this.expressionLanguage.evaluateLogExpression(token, event, componentLocation, bindingContext);
            if (evaluation.getValue() instanceof Message) {
                return evaluation.getValue();
            }
            try {
                return this.transform(evaluation, evaluation.getDataType(), DataType.STRING).getValue();
            }
            catch (TransformerException e) {
                throw new ExpressionRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Failed to transform %s to %s.", evaluation.getDataType(), DataType.STRING)), (Throwable)e);
            }
        }, template);
    }

    @Override
    public boolean isExpression(String expression) {
        return expression.contains("#[");
    }

    @Override
    public boolean isValid(String expression) {
        return this.validate(expression).isSuccess();
    }

    @Override
    public ValidationResult validate(String expression) {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Validate expressions is turned off, no checking done for: " + expression);
            }
            return new DefaultValidationResult(true, null);
        }
        StringBuilder message = new StringBuilder();
        if (!this.parser.isValid(expression)) {
            return ValidationResult.failure("Invalid Expression", expression);
        }
        AtomicBoolean valid = new AtomicBoolean(true);
        if (!expression.contains("#[")) {
            return this.expressionLanguage.validate(expression);
        }
        this.parser.parse(token -> {
            ValidationResult result;
            if (valid.get() && !(result = this.expressionLanguage.validate(token)).isSuccess()) {
                valid.compareAndSet(true, false);
                message.append(token).append(" is invalid\n");
                message.append(result.errorMessage().orElse(""));
            }
            return null;
        }, expression);
        if (message.length() > 0) {
            return ValidationResult.failure(message.toString());
        }
        return ValidationResult.success();
    }

    @Override
    public List<ConstraintViolation> validate(String script, String nameIdentifier, ValidationPhase validationScopePhase, TypeBindings typeBindings, Optional<MetadataType> outputType) {
        if (!this.muleContext.getConfiguration().isValidateExpressions()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Validate expressions is turned off, no checking done for: " + script);
            }
            return Collections.emptyList();
        }
        return this.expressionLanguage.validate(script, nameIdentifier, validationScopePhase, typeBindings, outputType);
    }

    @Override
    public Iterator<TypedValue<?>> split(String expression, BindingContext context) {
        return this.expressionLanguage.split(expression, null, context);
    }

    @Override
    public ExpressionManagerSession openSession(BindingContext context) {
        return new DefaultExpressionManagerSession(new LazyValue<Supplier<ExpressionLanguageSessionAdaptor>>(() -> this.expressionLanguage.openSession(null, null, context)), Thread.currentThread().getContextClassLoader());
    }

    @Override
    public ExpressionManagerSession openSession(ComponentLocation componentLocation, CoreEvent event, BindingContext context) {
        return new DefaultExpressionManagerSession(new LazyValue<Supplier<ExpressionLanguageSessionAdaptor>>(() -> this.expressionLanguage.openSession(componentLocation, event, context)), Thread.currentThread().getContextClassLoader());
    }

    @Inject
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    @Inject
    public void setTransformersRegistry(TransformersRegistry transformersRegistry) {
        this.transformersRegistry = transformersRegistry;
    }

    public StreamingManager getStreamingManager() {
        return this.muleContext.getStreamingManager();
    }

    public void setExpressionLanguage(ExtendedExpressionLanguageAdaptor expressionLanguage) {
        this.expressionLanguage = expressionLanguage;
    }

    public String toString() {
        return this.getClass().getName() + "[" + (this.expressionLanguage != null ? this.expressionLanguage.toString() : "null") + "]";
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.expressionLanguage);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.expressionLanguage, LOGGER);
    }
}

