/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.policy.api;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.policy.api.PolicyAwareAttributes;

public class SourcePolicyAwareAttributes
implements PolicyAwareAttributes {
    private final Set<String> headers;
    private final Set<Pattern> requestPathPatterns;

    private SourcePolicyAwareAttributes(Set<String> headers, Set<Pattern> requestPathPatterns) {
        Objects.requireNonNull(headers);
        Objects.requireNonNull(requestPathPatterns);
        this.headers = headers;
        this.requestPathPatterns = requestPathPatterns;
    }

    public static SourcePolicyAwareAttributes noAttributes() {
        return new SourcePolicyAwareAttributes(Collections.emptySet(), Collections.emptySet());
    }

    @Override
    public boolean requires(PolicyAwareAttributes.Attribute attribute) {
        switch ((SourceAttribute)attribute) {
            case HEADERS: {
                return this.requireHeaders();
            }
            case REQUEST_PATH: {
                return this.requireRequestPath();
            }
        }
        throw new IllegalArgumentException("Illegal attribute " + attribute);
    }

    @Override
    public PolicyAwareAttributes merge(PolicyAwareAttributes target) {
        SourcePolicyAwareAttributes that = (SourcePolicyAwareAttributes)target;
        Builder builder = new Builder();
        if (this.requireHeaders() || that.requireHeaders()) {
            builder.headers((String[])Sets.union(this.getHeaders(), that.getHeaders()).toArray((Object[])new String[0]));
        }
        if (this.requireRequestPath() || that.requireRequestPath()) {
            builder.requestPathPatterns((Pattern[])Sets.union(this.getRequestPathPatterns(), that.getRequestPathPatterns()).toArray((Object[])new Pattern[0]));
        }
        return builder.build();
    }

    public boolean requireHeaders() {
        return this.headers.size() > 0;
    }

    public Set<String> getHeaders() {
        return this.headers;
    }

    public boolean requireRequestPath() {
        return this.requestPathPatterns.size() > 0;
    }

    public Set<Pattern> getRequestPathPatterns() {
        return this.requestPathPatterns;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourcePolicyAwareAttributes that = (SourcePolicyAwareAttributes)o;
        return Objects.equals(this.headers, that.headers) && Objects.equals(this.requestPathPatterns, that.requestPathPatterns);
    }

    public int hashCode() {
        return Objects.hash(this.headers, this.requestPathPatterns);
    }

    public String toString() {
        return "SourcePolicyAwareAttributes{headers=" + this.headers + ", requestPathPatterns=" + this.requestPathPatterns + '}';
    }

    public static enum SourceAttribute implements PolicyAwareAttributes.Attribute
    {
        REQUEST_PATH,
        HEADERS;

    }

    public static class Builder {
        private Set<String> headers = new HashSet<String>();
        private Set<Pattern> requestPathPatterns = new HashSet<Pattern>();

        public Builder headers(String ... headers) {
            Preconditions.checkArgument(headers != null && headers.length > 0, "At least one header is required");
            this.headers = ImmutableSet.copyOf(Arrays.asList(headers));
            return this;
        }

        public Builder requestPathPatterns(Pattern ... requestPathPatterns) {
            Preconditions.checkArgument(requestPathPatterns != null && requestPathPatterns.length > 0, "At least one pattern is required");
            this.requestPathPatterns = ImmutableSet.copyOf(Arrays.asList(requestPathPatterns));
            return this;
        }

        public SourcePolicyAwareAttributes build() {
            return new SourcePolicyAwareAttributes(this.headers, this.requestPathPatterns);
        }
    }
}

