/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java;

import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParser;
import org.mule.runtime.extension.api.loader.parser.ExtensionModelParserFactory;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.loader.java.type.runtime.TypeWrapper;
import org.mule.runtime.module.extension.internal.loader.parser.java.JavaExtensionModelParser;

public class JavaExtensionModelParserFactory
implements ExtensionModelParserFactory {
    @Override
    public ExtensionModelParser createParser(ExtensionLoadingContext context) {
        return new JavaExtensionModelParser(JavaExtensionModelParserFactory.getExtensionElement(context), context);
    }

    public static ExtensionElement getExtensionElement(ExtensionLoadingContext context) {
        return ((ExtensionDeclaration)context.getExtensionDeclarer().getDeclaration()).getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(p -> {
            Type type = p.getType();
            if (type instanceof ExtensionElement) {
                return (ExtensionElement)type;
            }
            if (type instanceof TypeWrapper) {
                return new ExtensionTypeWrapper(type.getDeclaringClass().get(), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
            }
            throw new IllegalArgumentException("Unsupported declaration class type: " + type.getClass().getName());
        }).orElseGet(() -> context.getParameter("EXTENSION_TYPE").map(type -> JavaExtensionModelParserFactory.toExtensionElement(type)).orElseGet(() -> {
            String type = (String)context.getParameter("type").get();
            try {
                ClassLoader extensionClassLoader = context.getExtensionClassLoader();
                return new ExtensionTypeWrapper(Class.forName(type, true, extensionClassLoader), context.getTypeLoader());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(String.format("Class '%s' cannot be loaded", type), e);
            }
        }));
    }

    private static ExtensionElement toExtensionElement(Object type) {
        if (type instanceof ExtensionElement) {
            return (ExtensionElement)type;
        }
        if (type instanceof Class) {
            return new ExtensionTypeWrapper((Class)type, ExtensionsTypeLoaderFactory.getDefault().createTypeLoader());
        }
        throw new IllegalArgumentException("Unsupported extension type: " + String.valueOf(type));
    }
}

