/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModelBuilder;
import org.mule.runtime.api.util.FunctionalUtils;
import org.mule.runtime.extension.api.loader.parser.StereotypeModelFactory;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.module.extension.internal.loader.parser.java.stereotypes.JavaStereotypeModelParserUtils;
import org.mule.sdk.api.stereotype.StereotypeDefinition;

public class DefaultStereotypeModelFactory
implements StereotypeModelFactory {
    private final Map<StereotypeDefinition, StereotypeModel> stereotypesCache = new HashMap<StereotypeDefinition, StereotypeModel>();
    private String namespace;
    private StereotypeModel sourceParent;
    private StereotypeModel processorParent;
    private StereotypeModel validatorStereotype;

    @Override
    public StereotypeModel createStereotype(StereotypeDefinition stereotypeDefinition) {
        return this.createStereotype(stereotypeDefinition, this.namespace);
    }

    @Override
    public StereotypeModel createStereotype(StereotypeDefinition stereotypeDefinition, String namespace) {
        return FunctionalUtils.computeIfAbsent(this.stereotypesCache, stereotypeDefinition, definition -> {
            String resolvedNamespace = StringUtils.isBlank((CharSequence)stereotypeDefinition.getNamespace()) ? namespace : stereotypeDefinition.getNamespace();
            StereotypeModelBuilder builder = StereotypeModelBuilder.newStereotype(stereotypeDefinition.getName(), resolvedNamespace);
            stereotypeDefinition.getParent().ifPresent(parent -> {
                String parentNamespace = parent.getNamespace();
                if (StringUtils.isBlank((CharSequence)parentNamespace)) {
                    parentNamespace = namespace;
                }
                builder.withParent(this.createStereotype((StereotypeDefinition)parent, parentNamespace));
            });
            return builder.build();
        });
    }

    @Override
    public StereotypeModel createStereotype(String name, StereotypeModel parent) {
        return this.createStereotype(name, this.namespace, parent);
    }

    @Override
    public StereotypeModel createStereotype(final String name, String namespace, final StereotypeModel parent) {
        final String effectiveNamespace = namespace.toUpperCase();
        return this.createStereotype(new StereotypeDefinition(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public String getNamespace() {
                return effectiveNamespace;
            }

            @Override
            public Optional<StereotypeDefinition> getParent() {
                return Optional.ofNullable(parent).map(p -> JavaStereotypeModelParserUtils.asDefinition(p));
            }
        });
    }

    @Override
    public StereotypeModel getProcessorParentStereotype() {
        return this.processorParent;
    }

    @Override
    public StereotypeModel getSourceParentStereotype() {
        return this.sourceParent;
    }

    @Override
    public StereotypeModel getValidatorStereotype() {
        return this.validatorStereotype;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
        this.processorParent = StereotypeModelBuilder.newStereotype(MuleStereotypes.PROCESSOR.getType(), namespace).withParent(MuleStereotypes.PROCESSOR).build();
        this.sourceParent = StereotypeModelBuilder.newStereotype(MuleStereotypes.SOURCE.getType(), namespace).withParent(MuleStereotypes.SOURCE).build();
        this.validatorStereotype = StereotypeModelBuilder.newStereotype(MuleStereotypes.VALIDATOR_DEFINITION.getName(), namespace).withParent(org.mule.sdk.api.stereotype.MuleStereotypes.VALIDATOR).build();
    }
}

