/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.manager;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeArtifactExtensionManager
implements ExtensionManager,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeArtifactExtensionManager.class);
    private final ExtensionManager parentExtensionManager;
    private final ExtensionManager childExtensionManager;
    private final Set<ExtensionModel> extensionModels;

    public CompositeArtifactExtensionManager(ExtensionManager parentExtensionManager, ExtensionManager childExtensionManager) {
        Preconditions.checkArgument(parentExtensionManager != null, "parentExtensionManager cannot be null");
        Preconditions.checkArgument(childExtensionManager != null, "childExtensionManager cannot be null");
        this.parentExtensionManager = parentExtensionManager;
        this.childExtensionManager = childExtensionManager;
        this.extensionModels = new HashSet<ExtensionModel>();
        this.extensionModels.addAll(parentExtensionManager.getExtensions());
        this.extensionModels.addAll(childExtensionManager.getExtensions());
    }

    @Override
    public void registerExtension(ExtensionModel extensionModel) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extensions");
    }

    @Override
    public Set<ExtensionModel> getExtensions() {
        return this.extensionModels;
    }

    @Override
    public Optional<ExtensionModel> getExtension(String extensionName) {
        return this.extensionModels.stream().filter(extensionModel -> extensionModel.getName().equals(extensionName)).findFirst();
    }

    @Override
    public ConfigurationInstance getConfiguration(String configurationProviderName, CoreEvent event) {
        return this.getConfigurationProvider(configurationProviderName).map(provider -> provider.get(event)).orElseThrow(() -> new IllegalArgumentException(String.format("There is no registered configurationProvider under name '%s'", configurationProviderName)));
    }

    @Override
    public Optional<ConfigurationInstance> getConfiguration(ExtensionModel extensionModel, ComponentModel componentModel, CoreEvent event) {
        Optional<ConfigurationProvider> configurationProvider = this.getConfigurationProvider(extensionModel, componentModel, event);
        if (configurationProvider.isPresent()) {
            return configurationProvider.map(p -> p.get(event));
        }
        throw new IllegalArgumentException(String.format("There is no registered configuration provider for extension '%s'", extensionModel.getName()));
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel, CoreEvent event) {
        Optional<ConfigurationProvider> configuration = this.childExtensionManager.getConfigurationProvider(extensionModel, componentModel, event);
        if (configuration.isPresent()) {
            return configuration;
        }
        return this.getConfigurationProvider(extensionModel, componentModel);
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(String configurationProviderName) {
        Optional<ConfigurationProvider> configurationProvider = this.childExtensionManager.getConfigurationProvider(configurationProviderName);
        if (!configurationProvider.isPresent()) {
            configurationProvider = this.parentExtensionManager.getConfigurationProvider(configurationProviderName);
        }
        return configurationProvider;
    }

    @Override
    public Optional<ConfigurationProvider> getConfigurationProvider(ExtensionModel extensionModel, ComponentModel componentModel) {
        Optional<ConfigurationProvider> configurationModel = this.childExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        if (!configurationModel.isPresent()) {
            configurationModel = this.parentExtensionManager.getConfigurationProvider(extensionModel, componentModel);
        }
        return configurationModel;
    }

    @Override
    public void registerConfigurationProvider(ConfigurationProvider configurationProvider) {
        throw new UnsupportedOperationException("Composite extension manager cannot register extension providers");
    }

    @Override
    public void unregisterConfigurationProvider(ConfigurationProvider configurationProvider) {
        throw new UnsupportedOperationException("Composite extension manager cannot unregister extension providers");
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.childExtensionManager);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.childExtensionManager);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.childExtensionManager);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.childExtensionManager, LOGGER);
    }

    @Override
    public void disposeConfiguration(String key, ConfigurationInstance configuration) {
        this.parentExtensionManager.disposeConfiguration(key, configuration);
        this.childExtensionManager.disposeConfiguration(key, configuration);
    }

    public ExtensionManager getParentExtensionManager() {
        return this.parentExtensionManager;
    }

    public ExtensionManager getChildExtensionManager() {
        return this.childExtensionManager;
    }
}

