/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.streaming.iterator.ConsumerStreamingIterator;
import org.mule.runtime.core.api.streaming.iterator.ListConsumer;
import org.mule.runtime.core.internal.profiling.DummyComponentTracerFactory;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.connectivity.ExtensionConnectionSupplier;
import org.mule.runtime.module.extension.internal.runtime.operation.ResultTransformer;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderProducer;
import org.mule.runtime.tracer.api.component.ComponentTracer;
import org.mule.sdk.api.runtime.streaming.PagingProvider;

public class PagingResultTransformer
implements ResultTransformer {
    private final ExtensionConnectionSupplier connectionSupplier;
    private final boolean supportsOAuth;
    private ComponentTracer<CoreEvent> operationConnectionTracer = DummyComponentTracerFactory.DUMMY_COMPONENT_TRACER_INSTANCE;

    public PagingResultTransformer(ExtensionConnectionSupplier connectionSupplier, boolean supportsOAuth) {
        this.connectionSupplier = connectionSupplier;
        this.supportsOAuth = supportsOAuth;
    }

    public PagingResultTransformer(ExtensionConnectionSupplier connectionSupplier, boolean supportsOAuth, ComponentTracer<CoreEvent> operationConnectionTracer) {
        this(connectionSupplier, supportsOAuth);
        this.operationConnectionTracer = operationConnectionTracer;
    }

    @Override
    public Object applyChecked(ExecutionContextAdapter operationContext, Object value) {
        if (value == null) {
            throw new IllegalStateException("Obtained paging delegate cannot be null");
        }
        ConfigurationInstance config = operationContext.getConfiguration().get();
        PagingProviderProducer producer = new PagingProviderProducer((PagingProvider)value, config, operationContext, this.connectionSupplier, this.supportsOAuth, this.operationConnectionTracer);
        ListConsumer consumer = new ListConsumer(producer);
        consumer.loadNextPage();
        return new ConsumerStreamingIterator(consumer);
    }

    public void setOperationConnectionTracer(ComponentTracer<CoreEvent> coreEventComponentTracer) {
        this.operationConnectionTracer = coreEventComponentTracer;
    }
}

