/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.mule.internal.loader.parser;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.metadata.api.TypeLoader;
import org.mule.runtime.api.meta.Category;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.config.internal.dsl.utils.DslConstants;
import org.mule.runtime.extension.api.loader.ExtensionDevelopmentFramework;
import org.mule.runtime.extension.api.loader.parser.LicenseModelParser;
import org.mule.runtime.extension.api.loader.parser.MinMuleVersionParser;
import org.mule.runtime.extension.api.loader.parser.XmlDslConfiguration;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkExtensionModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkLicenseModelParser;
import org.mule.runtime.module.extension.mule.internal.loader.parser.MuleSdkMinMuleVersionParser;

public class MuleSdkApplicationExtensionModelParser
extends MuleSdkExtensionModelParser {
    public static final String APP_LOCAL_EXTENSION_NAMESPACE = "THIS";
    private static final String MIN_MULE_VERSION = "4.5";
    private final String extensionName;

    public MuleSdkApplicationExtensionModelParser(String extensionName, ArtifactAst ast, TypeLoader typeLoader, ExtensionModelHelper extensionModelHelper) {
        super(typeLoader, extensionModelHelper);
        this.extensionName = extensionName;
        this.init(ast);
    }

    @Override
    public String getName() {
        return this.extensionName;
    }

    @Override
    public Category getCategory() {
        return Category.COMMUNITY;
    }

    @Override
    public String getVendor() {
        return "Mulesoft";
    }

    @Override
    public Optional<XmlDslConfiguration> getXmlDslConfiguration() {
        return Optional.of(new XmlDslConfiguration("this", DslConstants.THIS_NAMESPACE));
    }

    @Override
    public String getNamespace() {
        return APP_LOCAL_EXTENSION_NAMESPACE;
    }

    @Override
    public Optional<MinMuleVersionParser> getResolvedMinMuleVersion() {
        return Optional.of(new MuleSdkMinMuleVersionParser(String.format("Application %s has min mule version %s because the Mule Sdk was introduced in that version.", this.extensionName, MIN_MULE_VERSION)));
    }

    @Override
    public ExtensionDevelopmentFramework getDevelopmentFramework() {
        return ExtensionDevelopmentFramework.MULE_DSL;
    }

    @Override
    public LicenseModelParser getLicensingParser() {
        return new MuleSdkLicenseModelParser(false, true, Optional.empty());
    }

    @Override
    protected Stream<ComponentAst> getTopLevelElements(ArtifactAst ast) {
        return ast.topLevelComponentsStream();
    }
}

