/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tooling.internal.config;

import java.io.File;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.config.custom.ServiceConfigurator;
import org.mule.runtime.api.connectivity.ConnectivityTestingService;
import org.mule.runtime.api.metadata.MetadataService;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.value.ValueProviderService;
import org.mule.runtime.core.api.data.sample.SampleDataService;
import org.mule.runtime.core.internal.util.store.MuleObjectStoreManager;
import org.mule.runtime.metadata.api.cache.MetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.internal.MuleMetadataService;
import org.mule.runtime.metadata.internal.cache.DefaultPersistentMetadataCacheManager;
import org.mule.runtime.metadata.internal.cache.MetadataCacheManager;
import org.mule.runtime.module.tooling.internal.config.RuntimeLockFactoryUtil;
import org.mule.runtime.module.tooling.internal.connectivity.DefaultConnectivityTestingService;
import org.mule.runtime.module.tooling.internal.connectivity.LazyConnectivityTestingService;
import org.mule.runtime.module.tooling.internal.data.sample.LazySampleDataService;
import org.mule.runtime.module.tooling.internal.data.sample.MuleSampleDataService;
import org.mule.runtime.module.tooling.internal.metadata.LazyMetadataService;
import org.mule.runtime.module.tooling.internal.metadata.cache.lazy.DelegateMetadataCacheIdGeneratorFactory;
import org.mule.runtime.module.tooling.internal.metadata.cache.lazy.DelegateMetadataCacheManager;
import org.mule.runtime.module.tooling.internal.metadata.model.ModelBasedMetadataCacheIdGeneratorFactory;
import org.mule.runtime.module.tooling.internal.store.SharedPartitionedPersistentObjectStore;
import org.mule.runtime.module.tooling.internal.value.LazyValueProviderService;
import org.mule.runtime.module.tooling.internal.value.MuleValueProviderService;

public class ToolingServicesConfigurator
implements ServiceConfigurator {
    public static final String SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH = "_sharedPartitionatedPersistentObjectStorePath";
    private static final String DEFAULT_METADATA_CACHE_MANAGER_KEY = "_defaultPersistentMetadataCacheManager";
    private static final String DEFAULT_METADATA_CACHE_ID_GENERATOR_KEY = "_defaultMetadataCacheIdGenerator";
    private static final String LAZY_MULE_OBJECT_STORE_MANAGER = "_muleLazyObjectStoreManager";

    @Override
    public void configure(CustomizationService customizationService) {
        if (!Boolean.parseBoolean(customizationService.getArtifactProperties().get("mule.application.deployment.addToolingObjectsToRegistry"))) {
            return;
        }
        customizationService.registerCustomServiceClass("_muleMetadataService", MuleMetadataService.class, false);
        customizationService.registerCustomServiceClass("_muleValueProviderService", MuleValueProviderService.class, false);
        customizationService.registerCustomServiceClass("_muleSampleDataService", MuleSampleDataService.class, false);
        customizationService.registerCustomServiceClass("_muleConnectivityTestingService", DefaultConnectivityTestingService.class, false);
        customizationService.registerCustomServiceClass("_metadataCacheManager", DefaultPersistentMetadataCacheManager.class, false);
        customizationService.registerCustomServiceClass("metadata.cache.id.model.generator.factory", ModelBasedMetadataCacheIdGeneratorFactory.class, false);
        if (Boolean.parseBoolean(customizationService.getArtifactProperties().get("mule.application.deployment.lazyInit"))) {
            this.configureLazyToolingServices(customizationService);
        }
    }

    private void configureLazyToolingServices(CustomizationService customizationService) {
        customizationService.registerCustomServiceImpl("_muleConnectivityTestingService", new LazyConnectivityTestingService(registry -> (ConnectivityTestingService)registry.lookupByName("_muleNonLazyConnectivityTestingService").get()), false);
        customizationService.registerCustomServiceClass("_muleNonLazyConnectivityTestingService", DefaultConnectivityTestingService.class, false);
        customizationService.registerCustomServiceImpl("_muleMetadataService", new LazyMetadataService(registry -> (MetadataService)registry.lookupByName("_muleNonLazyMetadataService").get()), false);
        customizationService.registerCustomServiceClass("_muleNonLazyMetadataService", MuleMetadataService.class, false);
        customizationService.registerCustomServiceImpl("_muleValueProviderService", new LazyValueProviderService(registry -> (ValueProviderService)registry.lookupByName("_muleNonLazyValueProviderService").get()), false);
        customizationService.registerCustomServiceClass("_muleNonLazyValueProviderService", MuleValueProviderService.class, false);
        customizationService.registerCustomServiceImpl("_muleSampleDataService", new LazySampleDataService(registry -> (SampleDataService)registry.lookupByName("_muleNonLazySampleDataService").get()), false);
        customizationService.registerCustomServiceClass("_muleNonLazySampleDataService", MuleSampleDataService.class, false);
        customizationService.registerCustomServiceClass(DEFAULT_METADATA_CACHE_ID_GENERATOR_KEY, ModelBasedMetadataCacheIdGeneratorFactory.class, false);
        customizationService.registerCustomServiceImpl("metadata.cache.id.model.generator.factory", new DelegateMetadataCacheIdGeneratorFactory(registry -> (MetadataCacheIdGeneratorFactory)registry.lookupByName(DEFAULT_METADATA_CACHE_ID_GENERATOR_KEY).get()), false);
        String sharedPartitionedPersistentObjectStorePath = customizationService.getArtifactProperties().get(SHARED_PARTITIONED_PERSISTENT_OBJECT_STORE_PATH);
        if (sharedPartitionedPersistentObjectStorePath != null) {
            customizationService.registerCustomServiceClass("_defaultSharedPersistentObjectStore", SharedPartitionedPersistentObjectStore.class);
            customizationService.registerCustomServiceImpl("_defaultSharedPersistentObjectStore", new SharedPartitionedPersistentObjectStore(new File(sharedPartitionedPersistentObjectStorePath), RuntimeLockFactoryUtil.getRuntimeLockFactory()));
            MuleObjectStoreManager osm = new MuleObjectStoreManager();
            osm.setBasePersistentStoreKey("_defaultSharedPersistentObjectStore");
            osm.setBaseTransientStoreKey("_defaultInMemoryObjectStore");
            customizationService.registerCustomServiceImpl(LAZY_MULE_OBJECT_STORE_MANAGER, osm);
            customizationService.registerCustomServiceClass(DEFAULT_METADATA_CACHE_MANAGER_KEY, DefaultPersistentMetadataCacheManager.class, false);
            customizationService.registerCustomServiceImpl("_metadataCacheManager", new DelegateMetadataCacheManager(this::lookupMetadataCacheManager), false);
        }
    }

    private MetadataCacheManager lookupMetadataCacheManager(Registry registry) {
        DefaultPersistentMetadataCacheManager defaultPersistentMetadataCacheManager = (DefaultPersistentMetadataCacheManager)registry.lookupByName(DEFAULT_METADATA_CACHE_MANAGER_KEY).get();
        defaultPersistentMetadataCacheManager.setLockFactory(RuntimeLockFactoryUtil.getRuntimeLockFactory());
        defaultPersistentMetadataCacheManager.setObjectStoreManager((ObjectStoreManager)registry.lookupByName(LAZY_MULE_OBJECT_STORE_MANAGER).get());
        return defaultPersistentMetadataCacheManager;
    }
}

