/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer.simple;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.serialization.ObjectSerializer;
import org.mule.runtime.api.serialization.SerializationProtocol;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.transformer.AbstractTransformer;
import org.mule.runtime.core.api.transformer.DiscoverableTransformer;
import org.mule.runtime.core.api.transformer.TransformerException;

public class ByteArrayToSerializable
extends AbstractTransformer
implements DiscoverableTransformer {
    private ObjectSerializer objectSerializer;
    private int priorityWeighting = 2;

    public ByteArrayToSerializable() {
        this.registerSourceType(DataType.BYTE_ARRAY);
        this.registerSourceType(DataType.INPUT_STREAM);
        this.registerSourceType(DataType.CURSOR_STREAM_PROVIDER);
    }

    @Override
    public Object doTransform(Object src, Charset encoding) throws TransformerException {
        SerializationProtocol externalProtocol = this.getSerializationProtocol();
        try {
            Object result = src instanceof byte[] ? externalProtocol.deserialize((byte[])src) : (src instanceof CursorStreamProvider ? externalProtocol.deserialize((InputStream)((CursorStreamProvider)src).openCursor()) : externalProtocol.deserialize((InputStream)src));
            return result;
        }
        catch (Exception e) {
            throw new TransformerException(CoreMessages.transformFailed("byte[]", "Object"), this, (Throwable)e);
        }
    }

    protected SerializationProtocol getSerializationProtocol() {
        return this.objectSerializer.getExternalProtocol();
    }

    @Override
    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    @Override
    public void setPriorityWeighting(int priorityWeighting) {
        this.priorityWeighting = priorityWeighting;
    }

    @Inject
    @Named(value="_muleDefaultObjectSerializer")
    public void setObjectSerializer(ObjectSerializer objectSerializer) {
        this.objectSerializer = objectSerializer;
    }
}

