/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class FlowRefPointsToNonPropertyValue
implements Validation {
    private static final String FLOW_REF_ELEMENT = "flow-ref";
    public static final ComponentIdentifier FLOW_REF_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("flow-ref").build();

    @Override
    public String getName() {
        return "'flow-ref's point to fixed flows";
    }

    @Override
    public String getDescription() {
        return "'flow-ref's point to fixed flows.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(FLOW_REF_IDENTIFIER)).and(ComponentAstPredicatesFactory.currentElemement(component -> !StringUtils.isEmpty((CharSequence)component.getParameter("General", "name").getRawValue())));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst param = component.getParameter("General", "name");
        String nameAttributeRawValue = param.getRawValue();
        if (MuleAstUtils.hasPropertyPlaceholder(nameAttributeRawValue)) {
            return Optional.of(ValidationResultItem.create(component, param, (Validation)this, "'flow-ref' is pointing to '" + nameAttributeRawValue + "' which is resolved with a property and may cause the artifact to have a different structure on different environments."));
        }
        return Optional.empty();
    }
}

