/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ArtifactType;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.internal.exception.FilteredErrorTypeRepository;

public final class ApplicationFilteredFromPolicyArtifactAst
extends BaseArtifactAst {
    private final ArtifactAst parentArtifactAst;
    private final FeatureFlaggingService featureFlaggingService;

    ApplicationFilteredFromPolicyArtifactAst(ArtifactAst parentArtifactAst, FeatureFlaggingService featureFlaggingService) {
        this.parentArtifactAst = parentArtifactAst;
        this.featureFlaggingService = featureFlaggingService;
    }

    @Override
    public String getArtifactName() {
        return this.parentArtifactAst.getArtifactName();
    }

    @Override
    public ArtifactType getArtifactType() {
        return ArtifactType.APPLICATION;
    }

    @Override
    public Set<ExtensionModel> dependencies() {
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return Collections.emptySet();
        }
        return this.parentArtifactAst.dependencies();
    }

    @Override
    public Optional<ArtifactAst> getParent() {
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return Optional.empty();
        }
        return this.parentArtifactAst.getParent();
    }

    @Override
    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return Stream.empty();
        }
        return this.parentArtifactAst.recursiveStream(direction);
    }

    @Override
    public List<ComponentAst> topLevelComponents() {
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return Collections.emptyList();
        }
        return this.parentArtifactAst.topLevelComponents();
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.parentArtifactAst.updatePropertiesResolver(newPropertiesResolver);
    }

    @Override
    public ErrorTypeRepository getErrorTypeRepository() {
        return new FilteredErrorTypeRepository(this.parentArtifactAst.getErrorTypeRepository(), new HashSet<String>(Arrays.asList("HTTP", Errors.CORE_NAMESPACE_NAME)));
    }

    @Override
    public Collection<ImportedResource> getImportedResources() {
        if (this.featureFlaggingService.isEnabled(MuleRuntimeFeature.ENABLE_POLICY_ISOLATION)) {
            return Collections.emptySet();
        }
        return this.parentArtifactAst.getImportedResources();
    }

    public static ArtifactAst applicationFilteredFromPolicyArtifactAst(ArtifactAst parentArtifactAst, FeatureFlaggingService featureFlaggingService) {
        return new ApplicationFilteredFromPolicyArtifactAst(parentArtifactAst, featureFlaggingService);
    }
}

