/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.client.source;

import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.config.ArtifactEncoding;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.source.MessageSource;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.internal.exception.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;
import org.mule.runtime.extension.api.client.source.SourceParameterizer;
import org.mule.runtime.extension.api.client.source.SourceResultHandler;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.module.extension.api.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.client.params.BaseParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.source.DefaultSourceParameterizer;
import org.mule.runtime.module.extension.internal.runtime.client.source.ExtensionsClientMessageProcessingManager;
import org.mule.runtime.module.extension.internal.runtime.resolver.NullResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetUtils;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionMessageSource;
import org.mule.runtime.module.extension.internal.runtime.source.SourceAdapterFactory;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceClient<T, A>
implements Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceClient.class);
    private final ExtensionModel extensionModel;
    private final SourceModel sourceModel;
    private final Consumer<SourceParameterizer> sourceParameterizerConsumer;
    private final Consumer<SourceResultHandler<T, A>> handlerConsumer;
    private final ExtensionManager extensionManager;
    private final StreamingManager streamingManager;
    private final ErrorTypeLocator errorTypeLocator;
    private final ReflectionCache reflectionCache;
    private final ExpressionManager expressionManager;
    private final NotificationDispatcher notificationDispatcher;
    private final MuleContext muleContext;
    private final ClassLoader extensionClassloader;
    private ExtensionMessageSource source;
    private MessagingExceptionResolver messagingExceptionResolver;
    private Optional<ConfigurationProvider> configurationProvider = Optional.empty();
    @Inject
    private ArtifactEncoding artifactEncoding;

    public SourceClient(ExtensionModel extensionModel, SourceModel sourceModel, Consumer<SourceParameterizer> sourceParameterizerConsumer, Consumer<SourceResultHandler<T, A>> handlerConsumer, ExtensionManager extensionManager, StreamingManager streamingManager, ErrorTypeLocator errorTypeLocator, ReflectionCache reflectionCache, ExpressionManager expressionManager, NotificationDispatcher notificationDispatcher, MuleContext muleContext) {
        this.extensionModel = extensionModel;
        this.sourceModel = sourceModel;
        this.sourceParameterizerConsumer = sourceParameterizerConsumer;
        this.handlerConsumer = handlerConsumer;
        this.extensionManager = extensionManager;
        this.streamingManager = streamingManager;
        this.errorTypeLocator = errorTypeLocator;
        this.reflectionCache = reflectionCache;
        this.expressionManager = expressionManager;
        this.notificationDispatcher = notificationDispatcher;
        this.muleContext = muleContext;
        this.extensionClassloader = MuleExtensionUtils.getClassLoader(extensionModel);
    }

    @Override
    public void initialise() throws InitialisationException {
        DefaultSourceParameterizer parameterizer = new DefaultSourceParameterizer();
        this.sourceParameterizerConsumer.accept(parameterizer);
        MessageSource.BackPressureStrategy backPressureStrategy = MuleExtensionUtils.toBackPressureStrategy(parameterizer.getBackPressureMode());
        CursorProviderFactory cursorProviderFactory = parameterizer.getCursorProviderFactory(this.streamingManager);
        SourceAdapterFactory sourceAdapterFactory = this.newSourceAdapterFactory(parameterizer, cursorProviderFactory, backPressureStrategy);
        this.configurationProvider = this.resolveConfigurationProvider(this.extensionManager, parameterizer);
        this.source = new ExtensionMessageSource(this.extensionModel, this.sourceModel, sourceAdapterFactory, this.configurationProvider.orElse(null), true, parameterizer.getRetryPolicyTemplate(), cursorProviderFactory, backPressureStrategy, this.extensionManager, this.notificationDispatcher, "");
        this.source.setAnnotations(SmallMap.of(AbstractComponent.LOCATION_KEY, DefaultComponentLocation.from(this.sourceModel.getName())));
        this.source.setListener(event -> event);
        LifecycleUtils.initialiseIfNeeded((Object)this.source, this.muleContext.getInjector());
        this.source.setMessageProcessingManager(new ExtensionsClientMessageProcessingManager<T, A>(this, this.handlerConsumer));
        this.messagingExceptionResolver = new MessagingExceptionResolver(this.source);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.source);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.source);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.source, LOGGER);
    }

    ResolverSet toResolverSet(BaseParameterizer parameterizer, ParameterizedModel model) {
        ComponentParameterization.Builder<ParameterizedModel> paramsBuilder = ComponentParameterization.builder(model);
        parameterizer.setValuesOn(paramsBuilder);
        try {
            ResolverSet resolverSet = ResolverSetUtils.getResolverSetFromComponentParameterization(paramsBuilder.build(), this.muleContext, true, this.reflectionCache, this.expressionManager, "", this.artifactEncoding);
            resolverSet.initialise();
            return resolverSet;
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception creating ResolverSet: " + e.getMessage()), (Throwable)e);
        }
    }

    Optional<ConfigurationInstance> resolveConfigurationInstance(CoreEvent event) {
        return this.configurationProvider.map(provider -> provider.get(event));
    }

    ClassLoader getExtensionClassLoader() {
        return this.extensionClassloader;
    }

    SourceModel getSourceModel() {
        return this.sourceModel;
    }

    MessagingException asMessagingException(Throwable t, CoreEvent event) {
        MessagingException exception = t instanceof MessagingException ? (MessagingException)t : new MessagingException(I18nMessageFactory.createStaticMessage(t.getMessage()), event, t, this.source);
        return this.messagingExceptionResolver.resolve(exception, this.errorTypeLocator, Collections.emptySet());
    }

    private SourceAdapterFactory newSourceAdapterFactory(DefaultSourceParameterizer parameterizer, CursorProviderFactory cursorProviderFactory, MessageSource.BackPressureStrategy backPressureStrategy) {
        return new SourceAdapterFactory(this.extensionModel, this.sourceModel, this.toResolverSet(parameterizer, this.sourceModel), NullResolverSet.INSTANCE, NullResolverSet.INSTANCE, cursorProviderFactory, backPressureStrategy, this.expressionManager, this.muleContext.getConfiguration().getDefaultEncoding(), this.muleContext.getExceptionListener());
    }

    private Optional<ConfigurationProvider> resolveConfigurationProvider(ExtensionManager extensionManager, DefaultSourceParameterizer parameterizer) {
        if (StringUtils.isBlank((CharSequence)parameterizer.getConfigRef())) {
            return Optional.empty();
        }
        Optional<ConfigurationProvider> cp = extensionManager.getConfigurationProvider(parameterizer.getConfigRef());
        if (!cp.isPresent()) {
            throw new IllegalArgumentException("No configuration registered for key '" + parameterizer.getConfigRef() + "'");
        }
        return cp;
    }
}

