/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.logging.otel.impl;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.OpenTelemetrySdk;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogRecordProcessor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.config.internal.model.dsl.config.DefaultConfigurationPropertiesResolver;
import org.mule.runtime.config.internal.model.dsl.config.SystemPropertiesConfigurationProvider;
import org.mule.runtime.logging.otel.impl.configuration.FileOpenTelemetryLoggingConfiguration;
import org.mule.runtime.logging.otel.impl.configuration.LogRecordExporterConfiguratorException;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryAutoConfigurableLoggingConfiguration;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingExporterBackpressureStrategy;
import org.mule.runtime.logging.otel.impl.configuration.OpenTelemetryLoggingExporterTransport;
import org.mule.runtime.logging.otel.impl.export.batch.BlockingBatchLogRecordProcessor;
import org.mule.runtime.logging.otel.impl.export.batch.BlockingBatchLogRecordProcessorBuilder;
import org.mule.runtime.logging.otel.impl.export.sniffer.ExportedLogRecordSniffer;
import org.mule.runtime.logging.otel.impl.export.sniffer.SniffedLogRecordExporter;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfiguration;
import org.mule.runtime.module.observability.configuration.ObservabilitySignalConfigurationFileFinder;

public class OpenTelemetryLoggingSDKFactory {
    private static final String SERVICE_NAMESPACE = "service.namespace";
    private static final String SERVICE_NAME = "service.name";
    private static final String DEFAULT_CONTAINER_SERVICE_NAME = "mule-container";
    private static final String USE_EXPORTER_SNIFFER = "mule.openTelemetry.logging.exporter.use.sniffer";
    private static final String MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_SCHEDULED_DELAY = "mule.openTelemetry.logging.exporter.batch.scheduledDelay";
    private static final SniffedLogRecordExporter sniffedLogRecordExporter = new SniffedLogRecordExporter(LogRecordExporter.composite((LogRecordExporter[])new LogRecordExporter[0]));

    private OpenTelemetryLoggingSDKFactory() {
    }

    public static OpenTelemetrySdk getOpenTelemetryLoggingSDK(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfigurationFileFinder loggingSignalConfigurationFinder) throws LogRecordExporterConfiguratorException {
        ObservabilitySignalConfiguration loggingExportConfiguration = OpenTelemetryLoggingSDKFactory.getLoggingExportConfiguration(deployableArtifactDescriptor, loggingSignalConfigurationFinder);
        Resource resource = OpenTelemetryLoggingSDKFactory.configureLoggingResource(deployableArtifactDescriptor, loggingExportConfiguration);
        SdkLoggerProvider sdkLoggerProvider = SdkLoggerProvider.builder().addResource(resource).addLogRecordProcessor(OpenTelemetryLoggingSDKFactory.getLogRecordProcessor(loggingExportConfiguration)).build();
        return OpenTelemetrySdk.builder().setLoggerProvider(sdkLoggerProvider).build();
    }

    private static LogRecordProcessor getLogRecordProcessor(ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        if (Boolean.getBoolean(USE_EXPORTER_SNIFFER)) {
            return SimpleLogRecordProcessor.create((LogRecordExporter)sniffedLogRecordExporter);
        }
        return OpenTelemetryLoggingSDKFactory.createBatchLogRecordProcessor(OpenTelemetryLoggingSDKFactory.getLogRecordExporter(loggingExportConfiguration), loggingExportConfiguration);
    }

    private static BlockingBatchLogRecordProcessor createBatchLogRecordProcessor(LogRecordExporter logRecordExporter, ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        BlockingBatchLogRecordProcessorBuilder batchLogRecordProcessorBuilder = BlockingBatchLogRecordProcessor.builder(logRecordExporter);
        int maxBatchSize = loggingExportConfiguration.getIntValue("mule.openTelemetry.logging.exporter.batch.maxSize");
        if (maxBatchSize < 512) {
            throw new LogRecordExporterConfiguratorException("The batch max size cannot be lower than 512");
        }
        int batchQueueSize = loggingExportConfiguration.getIntValue("mule.openTelemetry.logging.exporter.batch.queueSize");
        return batchLogRecordProcessorBuilder.setMaxQueueSize(batchQueueSize).setScheduleDelay(Long.getLong(MULE_OPEN_TELEMETRY_LOGGING_EXPORTER_BATCH_SCHEDULED_DELAY, OpenTelemetryAutoConfigurableLoggingConfiguration.DEFAULT_BATCH_SCHEDULE_DELAY_MILLIS), TimeUnit.MILLISECONDS).setBackpressureStrategy(OpenTelemetryLoggingExporterBackpressureStrategy.valueOf(loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.batch.backPressure.strategy"))).setMaxExportBatchSize(maxBatchSize).build();
    }

    private static LogRecordExporter getLogRecordExporter(ObservabilitySignalConfiguration loggingExportConfiguration) throws LogRecordExporterConfiguratorException {
        String type = loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.type");
        if (type == null) {
            throw new LogRecordExporterConfiguratorException("A type for log export was not configured.");
        }
        try {
            return OpenTelemetryLoggingExporterTransport.valueOf(type).getLoggingExporterConfigurator().configureExporter(loggingExportConfiguration);
        }
        catch (Exception e) {
            throw new LogRecordExporterConfiguratorException(e);
        }
    }

    public static ExportedLogRecordSniffer getLogRecordSniffer() {
        return sniffedLogRecordExporter.getExportedLogRecordSniffer();
    }

    private static ObservabilitySignalConfiguration getLoggingExportConfiguration(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfigurationFileFinder observabilitySignalArtifactResourceFinder) {
        return new OpenTelemetryAutoConfigurableLoggingConfiguration(new FileOpenTelemetryLoggingConfiguration(observabilitySignalArtifactResourceFinder, propertyReference -> new DefaultConfigurationPropertiesResolver(Optional.empty(), new SystemPropertiesConfigurationProvider()).apply(propertyReference), deployableArtifactDescriptor));
    }

    private static Resource configureLoggingResource(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) {
        return Resource.create((Attributes)Attributes.of((AttributeKey)AttributeKey.stringKey((String)SERVICE_NAME), (Object)OpenTelemetryLoggingSDKFactory.resolveServiceName(deployableArtifactDescriptor, loggingExportConfiguration), (AttributeKey)AttributeKey.stringKey((String)SERVICE_NAMESPACE), (Object)OpenTelemetryLoggingSDKFactory.resolveServiceNamespace(loggingExportConfiguration)));
    }

    private static String resolveServiceName(DeployableArtifactDescriptor deployableArtifactDescriptor, ObservabilitySignalConfiguration loggingExportConfiguration) {
        if (deployableArtifactDescriptor != null) {
            return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.service.name", deployableArtifactDescriptor.getName());
        }
        return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporter.resource.service.name", DEFAULT_CONTAINER_SERVICE_NAME);
    }

    private static String resolveServiceNamespace(ObservabilitySignalConfiguration loggingExportConfiguration) {
        return loggingExportConfiguration.getStringValue("mule.openTelemetry.logging.exporterresource.service.namespace");
    }
}

