/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.event.Event;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.notification.Notification;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.TransactionProfilingEventContext;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.collection.SmallMap;
import org.mule.runtime.core.api.transaction.TransactionUtils;
import org.mule.runtime.core.internal.execution.NotificationFunction;
import org.mule.runtime.extension.api.tx.TransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.notification.DefaultExtensionNotification;
import org.mule.runtime.module.extension.internal.runtime.source.ExtensionNotificationFunction;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.SourceCallbackContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.source.trace.SourceDistributedTraceContextManager;
import org.mule.runtime.module.extension.internal.runtime.transaction.DefaultTransactionHandle;
import org.mule.runtime.module.extension.internal.runtime.transaction.NullTransactionHandle;
import org.mule.sdk.api.connectivity.TransactionalConnection;
import org.mule.sdk.api.notification.NotificationActionDefinition;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultSourceCallbackContext
implements SourceCallbackContextAdapter {
    private static final TransactionHandle NULL_TRANSACTION_HANDLE = new NullTransactionHandle();
    private static final TransactionHandle DEFAULT_TRANSACTION_HANDLE = new DefaultTransactionHandle();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSourceCallbackContext.class);
    private final SourceCallbackAdapter sourceCallback;
    private final Map<String, Object> variables = new SmallMap<String, Object>();
    private String correlationId;
    private Object connection = null;
    private TransactionHandle transactionHandle = NULL_TRANSACTION_HANDLE;
    private boolean dispatched = false;
    private final List<NotificationFunction> notificationFunctions = new LinkedList<NotificationFunction>();
    private ProfilingDataProducer<TransactionProfilingEventContext, Object> startProducer;
    private DistributedTraceContextManager sourceDistributedTraceContext = new SourceDistributedTraceContextManager();
    private final ProfilingService profilingService;
    private final boolean errorAfterTimeout;

    DefaultSourceCallbackContext(SourceCallbackAdapter sourceCallback, ProfilingService profilingService, boolean errorAfterTimeout) {
        this.sourceCallback = sourceCallback;
        this.profilingService = profilingService;
        this.errorAfterTimeout = errorAfterTimeout;
    }

    @Override
    public TransactionHandle bindConnection(Object connection) throws ConnectionException, TransactionException {
        Preconditions.checkArgument(connection != null, "Cannot bind a null connection");
        if (this.connection != null) {
            throw new IllegalStateException("Connection can only be set once per " + SourceCallbackContext.class.getSimpleName());
        }
        this.connection = connection;
        try {
            if (this.sourceCallback.getTransactionConfig().isTransacted() && connection instanceof TransactionalConnection) {
                ConnectionHandler<Object> connectionHandler = this.sourceCallback.getSourceConnectionManager().getConnectionHandler(connection).orElseThrow(() -> new TransactionException(this.createWrongConnectionMessage(connection)));
                this.sourceCallback.getTransactionSourceBinder().bindToTransaction(this.sourceCallback.getTransactionConfig(), this.sourceCallback.getConfigurationInstance(), this.sourceCallback.getSourceLocation(), connectionHandler, this.sourceCallback.getTimeout(), this.errorAfterTimeout);
                if (this.sourceCallback.getTransactionConfig().isTransacted()) {
                    this.initialiseProfilingDataProducerIfNeeded();
                    TransactionUtils.profileTransactionAction(this.startProducer, RuntimeProfilingEventTypes.TX_START, this.sourceCallback.getSourceLocation());
                }
                this.transactionHandle = DEFAULT_TRANSACTION_HANDLE;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Connection could not be bound", (Throwable)e);
            this.releaseConnection();
            throw e;
        }
        return this.transactionHandle;
    }

    private void initialiseProfilingDataProducerIfNeeded() {
        if (this.startProducer == null) {
            this.startProducer = this.profilingService.getProfilingDataProducer(RuntimeProfilingEventTypes.TX_START);
        }
    }

    @Override
    public <T> T getConnection() {
        if (this.connection == null) {
            throw new IllegalStateException("No connection has been bound");
        }
        return (T)this.connection;
    }

    @Override
    public void dispatched() {
        this.dispatched = true;
    }

    @Override
    public void releaseConnection() {
        if (this.connection != null) {
            this.sourceCallback.getSourceConnectionManager().release(this.connection);
            this.connection = null;
        }
    }

    @Override
    public TransactionHandle getTransactionHandle() {
        return this.transactionHandle;
    }

    @Override
    public boolean hasVariable(String variableName) {
        return this.variables.containsKey(variableName);
    }

    @Override
    public <T> Optional<T> getVariable(String variableName) {
        return Optional.ofNullable(this.variables.get(variableName));
    }

    @Override
    public void addVariable(String variableName, Object value) {
        this.variables.put(variableName, value);
    }

    @Override
    public void setCorrelationId(String correlationId) {
        Preconditions.checkState(!this.dispatched, "Cannot set the correlationId at this moment. This context was already used to dispatch a message");
        this.correlationId = correlationId;
    }

    @Override
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(this.correlationId);
    }

    @Override
    public <T, A> SourceCallback<T, A> getSourceCallback() {
        return this.sourceCallback;
    }

    @Override
    public void fireOnHandle(final NotificationActionDefinition<?> action, final TypedValue<?> data) {
        this.notificationFunctions.add(new ExtensionNotificationFunction(){

            @Override
            public String getActionName() {
                return ((Enum)((Object)action)).name();
            }

            @Override
            public Notification apply(Event event, Component component) {
                return new DefaultExtensionNotification(event, component, action, data);
            }
        });
    }

    @Override
    public DistributedTraceContextManager getDistributedSourceTraceContext() {
        return this.sourceDistributedTraceContext;
    }

    @Override
    public List<NotificationFunction> getNotificationsFunctions() {
        return this.notificationFunctions;
    }

    private I18nMessage createWrongConnectionMessage(Object connection) {
        return I18nMessageFactory.createStaticMessage(String.format("Internal Error. The transacted source [%s] from the Extension [%s] tried to bind an connection of type [%s] which is not a connection created by this extension. ", this.sourceCallback.getOwningSourceName(), this.sourceCallback.getOwningExtensionName(), connection.getClass().getName()));
    }
}

