/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.api.model;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;

class ImmutableMavenConfiguration
implements MavenConfiguration {
    private final List<RemoteRepository> remoteRepositories;
    private final File localMavenRepositoryLocation;
    private final Optional<File> userSettingsFileOptional;
    private final Optional<File> globalSettingsFileOptional;
    private boolean forcePolicyUpdateNever;
    private boolean forcePolicyUpdateAlways;
    private boolean offlineMode;
    private boolean ignoreArtifactDescriptorRepositories;
    private final File settingsSecurityFile;
    private final List<String> activeProfiles;
    private final List<String> inactiveProfiles;
    private final Properties userProperties;
    private String globalChecksumPolicy;

    public ImmutableMavenConfiguration(File localMavenRepositoryLocation, List<RemoteRepository> remoteRepositories, Optional<File> userSettingsFileOptional, Optional<File> globalSettingsFileOptional, boolean forcePolicyUpdateNever, boolean forcePolicyUpdateAlways, boolean offlineMode, boolean ignoreArtifactDescriptorRepositories, File settingsSecurityFile, List<String> activeProfiles, List<String> inactiveProfiles, Properties userProperties, String globalChecksumPolicy) {
        Set uniqueIdList = remoteRepositories.stream().map(RemoteRepository::getId).collect(Collectors.toSet());
        if (uniqueIdList.size() != remoteRepositories.size()) {
            throw new IllegalStateException("The configured set of remote repositories do not have unique IDs");
        }
        this.localMavenRepositoryLocation = localMavenRepositoryLocation;
        this.remoteRepositories = remoteRepositories;
        this.userSettingsFileOptional = userSettingsFileOptional;
        this.globalSettingsFileOptional = globalSettingsFileOptional;
        this.forcePolicyUpdateNever = forcePolicyUpdateNever;
        this.forcePolicyUpdateAlways = forcePolicyUpdateAlways;
        this.offlineMode = offlineMode;
        this.ignoreArtifactDescriptorRepositories = ignoreArtifactDescriptorRepositories;
        this.settingsSecurityFile = settingsSecurityFile;
        this.activeProfiles = activeProfiles != null ? activeProfiles : Collections.emptyList();
        this.inactiveProfiles = inactiveProfiles != null ? inactiveProfiles : Collections.emptyList();
        this.userProperties = userProperties;
        this.globalChecksumPolicy = globalChecksumPolicy;
    }

    @Override
    public File getLocalMavenRepositoryLocation() {
        return this.localMavenRepositoryLocation;
    }

    @Override
    public List<RemoteRepository> getMavenRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public Optional<File> getUserSettingsLocation() {
        return this.userSettingsFileOptional;
    }

    @Override
    public Optional<File> getGlobalSettingsLocation() {
        return this.globalSettingsFileOptional;
    }

    @Override
    public Optional<File> getSettingsSecurityLocation() {
        return Optional.ofNullable(this.settingsSecurityFile);
    }

    @Override
    public boolean getForcePolicyUpdateNever() {
        return this.forcePolicyUpdateNever;
    }

    @Override
    public boolean getForcePolicyUpdateAlways() {
        return this.forcePolicyUpdateAlways;
    }

    @Override
    public String getGlobalChecksumPolicy() {
        return this.globalChecksumPolicy;
    }

    @Override
    public boolean getOfflineMode() {
        return this.offlineMode;
    }

    @Override
    public boolean getIgnoreArtifactDescriptorRepositories() {
        return this.ignoreArtifactDescriptorRepositories;
    }

    @Override
    public Optional<Properties> getUserProperties() {
        return Optional.ofNullable(this.userProperties);
    }

    @Override
    public Optional<List<String>> getActiveProfiles() {
        return Optional.ofNullable(this.activeProfiles);
    }

    @Override
    public Optional<List<String>> getInactiveProfiles() {
        return Optional.ofNullable(this.inactiveProfiles);
    }

    public String toString() {
        return "ImmutableMavenConfiguration{remoteRepositories=" + this.repositoriesToString() + ", localMavenRepositoryLocation=" + this.localMavenRepositoryLocation + ", userSettingsFileOptional=" + this.userSettingsFileOptional + (this.settingsSecurityFile != null ? ", settingsSecurityFile=" + this.settingsSecurityFile : "") + ", globalSettingsFileOptional=" + this.globalSettingsFileOptional + ", forcePolicyUpdateNever=" + this.forcePolicyUpdateNever + ", forcePolicyUpdateAlways=" + this.forcePolicyUpdateAlways + ", offlineMode=" + this.offlineMode + ", ignoreArtifactDescriptorRepositories=" + this.ignoreArtifactDescriptorRepositories + ", activeProfiles=" + this.activeProfiles + ", inactiveProfiles=" + this.inactiveProfiles + ", globalChecksumPolicy=" + this.globalChecksumPolicy + '}';
    }

    private String repositoriesToString() {
        return String.join((CharSequence)",\n", this.remoteRepositories.stream().map(Object::toString).collect(Collectors.toList()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMavenConfiguration that = (ImmutableMavenConfiguration)o;
        if (this.forcePolicyUpdateNever != that.forcePolicyUpdateNever) {
            return false;
        }
        if (this.forcePolicyUpdateAlways != that.forcePolicyUpdateAlways) {
            return false;
        }
        if (this.globalChecksumPolicy != that.globalChecksumPolicy) {
            return false;
        }
        if (this.offlineMode != that.offlineMode) {
            return false;
        }
        if (this.ignoreArtifactDescriptorRepositories != that.ignoreArtifactDescriptorRepositories) {
            return false;
        }
        if (!this.remoteRepositories.equals(that.remoteRepositories)) {
            return false;
        }
        if (!this.localMavenRepositoryLocation.equals(that.localMavenRepositoryLocation)) {
            return false;
        }
        if (!this.userSettingsFileOptional.equals(that.userSettingsFileOptional)) {
            return false;
        }
        if (!this.globalSettingsFileOptional.equals(that.globalSettingsFileOptional)) {
            return false;
        }
        if (!Objects.equals(this.settingsSecurityFile, that.settingsSecurityFile)) {
            return false;
        }
        if (!Objects.equals(this.activeProfiles, that.activeProfiles)) {
            return false;
        }
        if (!Objects.equals(this.inactiveProfiles, that.inactiveProfiles)) {
            return false;
        }
        return Objects.equals(this.userProperties, that.userProperties);
    }

    public int hashCode() {
        int result = this.remoteRepositories.hashCode();
        result = 31 * result + this.localMavenRepositoryLocation.hashCode();
        result = 31 * result + this.userSettingsFileOptional.hashCode();
        result = 31 * result + this.globalSettingsFileOptional.hashCode();
        result = 31 * result + (this.forcePolicyUpdateNever ? 1 : 0);
        result = 31 * result + (this.forcePolicyUpdateAlways ? 1 : 0);
        result = 31 * result + (this.offlineMode ? 1 : 0);
        result = 31 * result + (this.ignoreArtifactDescriptorRepositories ? 1 : 0);
        result = 31 * result + (this.settingsSecurityFile != null ? this.settingsSecurityFile.hashCode() : 0);
        result = 31 * result + (this.activeProfiles != null ? this.activeProfiles.hashCode() : 0);
        result = 31 * result + (this.inactiveProfiles != null ? this.inactiveProfiles.hashCode() : 0);
        result = 31 * result + (this.userProperties != null ? this.userProperties.hashCode() : 0);
        result = 31 * result + (this.globalChecksumPolicy != null ? this.globalChecksumPolicy.hashCode() : 0);
        return result;
    }
}

