/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.api.annotation;

import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.serialization.CustomCopySerialization;
import org.mule.metadata.java.api.utils.TypeResolver;

public class ClassInformationAnnotation
implements TypeAnnotation,
CustomCopySerialization {
    public static final String INTERNAL_METADATA_PACKAGE = "org.mule.runtime.api.component.";
    public static final String NAME = "classInformation";
    private final String classname;
    private final boolean hasDefaultConstructor;
    private final boolean isInterface;
    private final boolean isInstantiable;
    private final boolean isAbstract;
    private final boolean isFinal;
    private final List<String> implementedInterfaces;
    private final String parent;
    private final List<String> genericTypes;
    private final boolean isMap;

    public ClassInformationAnnotation(String classname, boolean hasDefaultConstructor, boolean isInterface, boolean isInstantiable, boolean isAbstract, boolean isFinal, List<String> implementedInterfaces, String parent, List<String> genericTypes, boolean isMap) {
        this.classname = classname;
        this.hasDefaultConstructor = hasDefaultConstructor;
        this.isInterface = isInterface;
        this.isInstantiable = isInstantiable;
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.implementedInterfaces = implementedInterfaces;
        this.parent = parent;
        this.genericTypes = genericTypes;
        this.isMap = isMap;
    }

    public ClassInformationAnnotation(Class<?> clazz) {
        this(clazz, Collections.emptyList());
    }

    public ClassInformationAnnotation(Class<?> clazz, List<Type> genericTypes) {
        this.classname = ClassInformationAnnotation.getName(clazz);
        this.implementedInterfaces = this.getImplementedInterfaces(clazz);
        this.parent = this.getParentClass(clazz);
        this.isFinal = Modifier.isFinal(clazz.getModifiers());
        this.isAbstract = Modifier.isAbstract(clazz.getModifiers());
        this.isInterface = clazz.isInterface();
        this.hasDefaultConstructor = this.hasDefaultConstructor(clazz);
        this.genericTypes = this.getGenerics(genericTypes);
        this.isInstantiable = !this.isInterface && !this.isAbstract && this.hasDefaultConstructor;
        this.isMap = Map.class.isAssignableFrom(clazz);
    }

    public static String getName(Class<?> clazz) {
        if (!clazz.getName().startsWith("[")) {
            return clazz.getName();
        }
        String name = clazz.getName();
        if (!name.contains("$")) {
            return clazz.getCanonicalName();
        }
        String CanonicalName = clazz.getCanonicalName();
        int indexToChange = CanonicalName.lastIndexOf(".");
        return CanonicalName.substring(0, indexToChange) + "$" + CanonicalName.substring(indexToChange + 1);
    }

    private List<String> getGenerics(List<Type> genericTypes) {
        if (genericTypes != null && !genericTypes.isEmpty()) {
            return Collections.unmodifiableList(genericTypes.stream().map(TypeResolver::erase).map(Type::getTypeName).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    private List<String> getImplementedInterfaces(Class<?> clazz) {
        return Collections.unmodifiableList(Arrays.stream(clazz.getInterfaces()).map(Class::getCanonicalName).filter(name -> name != null).filter(name -> !name.startsWith(INTERNAL_METADATA_PACKAGE)).collect(Collectors.toList()));
    }

    private String getParentClass(Class<?> clazz) {
        Class<?> parent = clazz.getSuperclass();
        return parent != null && !parent.equals(Object.class) && !parent.getName().startsWith(INTERNAL_METADATA_PACKAGE) ? parent.getName() : "";
    }

    private boolean hasDefaultConstructor(Class<?> clazz) {
        return !this.isInterface && Arrays.stream(clazz.getDeclaredConstructors()).anyMatch(c -> c.getParameterCount() == 0 && Modifier.isPublic(c.getModifiers()));
    }

    @Override
    public TypeAnnotation serializationCopy() {
        return new ClassInformationAnnotation(this.classname, this.hasDefaultConstructor, this.isInterface, this.isInstantiable, this.isAbstract, this.isFinal, this.implementedInterfaces.stream().filter(inter -> !inter.startsWith("java.")).collect(Collectors.toList()), this.parent, this.genericTypes, this.isMap);
    }

    @Override
    public String getName() {
        return NAME;
    }

    public String getClassname() {
        return this.classname;
    }

    public boolean isInstantiable() {
        return this.isInstantiable;
    }

    public List<String> getGenericTypes() {
        return this.genericTypes;
    }

    public Optional<String> getParent() {
        return StringUtils.isNotBlank((CharSequence)this.parent) ? Optional.of(this.parent) : Optional.empty();
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isMap() {
        return this.isMap;
    }

    public List<String> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public boolean hasDefaultConstructor() {
        return this.hasDefaultConstructor;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClassInformationAnnotation) {
            return Objects.equals(this.classname, ((ClassInformationAnnotation)obj).classname) && Objects.equals(this.genericTypes, ((ClassInformationAnnotation)obj).genericTypes);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.classname, this.genericTypes);
    }

    public String toString() {
        return this.classname + (this.genericTypes.isEmpty() ? "" : this.genericTypes.stream().collect(Collectors.joining(", ", "<", ">")));
    }
}

