/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.application;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.core.api.config.DefaultMuleConfiguration;
import org.mule.runtime.core.api.config.ReconfigurableMuleConfiguration;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.runtime.module.deployment.impl.internal.application.SupportsPropertiesMuleContextBuilder;

public class PolicyMuleContextBuilder
extends SupportsPropertiesMuleContextBuilder {
    private final String policyName;
    private final String defaultEncoding;

    public PolicyMuleContextBuilder(String policyName, Map<String, String> policyProperties, String defaultEncoding) {
        super(ArtifactType.POLICY, policyProperties);
        this.policyName = policyName;
        this.defaultEncoding = defaultEncoding;
    }

    @Override
    protected DefaultMuleConfiguration createMuleConfiguration() {
        DefaultMuleConfiguration configuration = Boolean.valueOf(this.getArtifactProperties().get("mule.application.deployment.lazyInit")) != false ? new ReconfigurableMuleConfiguration(true) : new DefaultMuleConfiguration(true);
        this.initializeFromProperties(configuration);
        configuration.setId(this.policyName);
        String encoding = this.defaultEncoding;
        if (!StringUtils.isBlank((CharSequence)encoding)) {
            configuration.setDefaultEncoding(encoding);
        }
        if (this.executionClassLoader instanceof MuleArtifactClassLoader) {
            configuration.setMinMuleVersion(((ArtifactDescriptor)((MuleArtifactClassLoader)this.executionClassLoader).getArtifactDescriptor()).getMinMuleVersion());
        }
        return configuration;
    }
}

