/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.util.NameValidationUtil;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class NameHasValidCharacters
implements Validation {
    @Override
    public String getName() {
        return "Names have valid characters";
    }

    @Override
    public String getDescription() {
        return "'name' attribute in top-level elements only have valid characters.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getComponentId().isPresent()));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        String nameAttributeValue = component.getComponentId().get();
        try {
            NameValidationUtil.verifyStringDoesNotContainsReservedCharacters(nameAttributeValue);
            return Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.of(ValidationResultItem.create(component, this, "Invalid global element name '" + nameAttributeValue + "'. Problem is: " + e.getMessage(), MuleAstUtils.hasPropertyPlaceholder(nameAttributeValue)));
        }
    }
}

