/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.el;

import java.nio.charset.Charset;
import java.util.Optional;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.el.DefaultExpressionLanguageConfiguration;
import org.mule.runtime.api.el.ExpressionLanguageConfiguration;
import org.mule.runtime.api.meta.MuleVersion;

public class ExpressionLanguageConfigurationBuilder {
    private Charset charset = Charset.defaultCharset();
    private FeatureFlaggingService featureFlaggingService;
    private String appId;
    private Optional<MuleVersion> minMuleVersion;

    ExpressionLanguageConfigurationBuilder() {
    }

    public ExpressionLanguageConfigurationBuilder defaultEncoding(Charset charset) {
        this.charset = charset;
        return this;
    }

    public ExpressionLanguageConfigurationBuilder featureFlaggingService(FeatureFlaggingService featureFlaggingService) {
        this.featureFlaggingService = featureFlaggingService;
        return this;
    }

    public ExpressionLanguageConfigurationBuilder appId(String id) {
        this.appId = id;
        return this;
    }

    public ExpressionLanguageConfigurationBuilder minMuleVersion(Optional<MuleVersion> minMuleVersion) {
        this.minMuleVersion = minMuleVersion;
        return this;
    }

    public ExpressionLanguageConfiguration build() {
        return new DefaultExpressionLanguageConfiguration(this.charset, this.featureFlaggingService, this.appId, this.minMuleVersion);
    }
}

