/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.context.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.ioc.ConfigurableObjectProvider;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.internal.context.lazy.ComponentInitializationRequest;
import org.mule.runtime.config.internal.context.lazy.TrackingPostProcessor;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;

class ComponentInitializationState {
    private final ConfigurationComponentLocator componentLocator;
    private TrackingPostProcessor trackingPostProcessor = new TrackingPostProcessor();
    private final Set<String> currentComponentLocationsRequested = new HashSet<String>();
    private final List<ConfigurableObjectProvider> objectProvidersToConfigure = new ArrayList<ConfigurableObjectProvider>();
    private boolean isApplyStartPhaseRequested = false;
    private boolean isInitializationAlreadyDone = false;
    private boolean isAllErrorTypesRegistered = false;

    ComponentInitializationState(ConfigurationComponentLocator componentLocator) {
        this.componentLocator = componentLocator;
    }

    public boolean isApplyStartPhaseRequested() {
        return this.isApplyStartPhaseRequested;
    }

    public boolean isInitializationAlreadyDone() {
        return this.isInitializationAlreadyDone;
    }

    public boolean isAllErrorTypesRegistered() {
        return this.isAllErrorTypesRegistered;
    }

    public void setAllErrorTypesRegistered() {
        this.isAllErrorTypesRegistered = true;
    }

    public void registerTrackingPostProcessor(ConfigurableListableBeanFactory beanFactory) {
        this.trackingPostProcessor = new TrackingPostProcessor();
        beanFactory.addBeanPostProcessor((BeanPostProcessor)this.trackingPostProcessor);
    }

    public void startTrackingBeans() {
        this.trackingPostProcessor.startTracking();
    }

    public void commitTrackedBeansContainedIn(Collection<String> beanNames) {
        this.trackingPostProcessor.commitOnly(beanNames);
    }

    public List<String> getTrackedBeansInOrder() {
        return this.trackingPostProcessor.getBeansTrackedInOrder();
    }

    public void registerObjectProviderToConfigure(ConfigurableObjectProvider objectProvider) {
        this.objectProvidersToConfigure.add(objectProvider);
    }

    public List<ConfigurableObjectProvider> takeObjectProvidersToConfigure() {
        ArrayList<ConfigurableObjectProvider> returnValue = new ArrayList<ConfigurableObjectProvider>(this.objectProvidersToConfigure);
        this.objectProvidersToConfigure.clear();
        return returnValue;
    }

    public boolean isRequestSatisfied(ComponentInitializationRequest componentInitializationRequest) {
        return this.areLocationsSatisfied(componentInitializationRequest) && this.isApplyStartPhaseRequested == componentInitializationRequest.isApplyStartPhaseRequested();
    }

    public boolean isComponentAlreadyInitialized(ComponentAst componentAst) {
        return componentAst.getLocation() == null || this.componentLocator.find(this.getLocation(componentAst)).isPresent();
    }

    public void update(ComponentInitializationRequest componentInitializationRequest) {
        this.isInitializationAlreadyDone = true;
        if (!componentInitializationRequest.isKeepPreviousRequested()) {
            this.currentComponentLocationsRequested.clear();
            this.trackingPostProcessor.reset();
        }
        this.currentComponentLocationsRequested.addAll(componentInitializationRequest.getRequestedLocations());
        this.isApplyStartPhaseRequested = componentInitializationRequest.isApplyStartPhaseRequested();
    }

    public void clear() {
        this.trackingPostProcessor = new TrackingPostProcessor();
        this.trackingPostProcessor.stopTracking();
        this.trackingPostProcessor.reset();
        this.isApplyStartPhaseRequested = false;
        this.isInitializationAlreadyDone = false;
        this.isAllErrorTypesRegistered = false;
        this.currentComponentLocationsRequested.clear();
        this.objectProvidersToConfigure.clear();
    }

    private Location getLocation(ComponentAst componentAst) {
        return Location.builderFromStringRepresentation(componentAst.getLocation().getLocation()).build();
    }

    private boolean areLocationsSatisfied(ComponentInitializationRequest componentInitializationRequest) {
        Set<String> requestedLocations = componentInitializationRequest.getRequestedLocations();
        return componentInitializationRequest.isKeepPreviousRequested() ? this.currentComponentLocationsRequested.containsAll(requestedLocations) : this.currentComponentLocationsRequested.equals(requestedLocations);
    }
}

