/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.transformer;

import jakarta.inject.Inject;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.transformer.Converter;
import org.mule.runtime.core.api.transformer.DataTypeConversionResolver;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.transformer.DefaultTransformationService;
import org.mule.runtime.core.internal.transformer.TransformerUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoInstantiate
public class ExtendedTransformationService
extends DefaultTransformationService {
    private static final Logger logger = LoggerFactory.getLogger(ExtendedTransformationService.class);
    private DataTypeConversionResolver dataTypeConversionResolver;

    public Message applyTransformers(Message message, CoreEvent event, List<? extends Transformer> transformers) throws MuleException {
        return this.applyAllTransformers(message, event, transformers);
    }

    public Message applyTransformers(Message message, CoreEvent event, Transformer ... transformers) throws MuleException {
        return this.applyAllTransformers(message, event, Arrays.asList(transformers));
    }

    public String getPayloadForLogging(Message message) {
        return this.getPayloadForLogging(message, this.resolveEncoding(message));
    }

    public String getPayloadForLogging(Message message, Charset encoding) {
        DataType dataType = message.getPayload().getDataType();
        if (!dataType.isStreamType()) {
            try {
                return (String)this.getPayload(message, DataType.STRING, encoding);
            }
            catch (MessageTransformerException e) {
                return "Payload could not be converted to a String. Payload type is " + String.valueOf(dataType.getType());
            }
        }
        return "Payload is a stream of type: " + String.valueOf(dataType.getType());
    }

    private Message applyAllTransformers(Message message, CoreEvent event, List<? extends Transformer> transformers) throws MuleException {
        Message result = message;
        if (!transformers.isEmpty()) {
            for (int index = 0; index < transformers.size(); ++index) {
                Class<?> srcCls;
                DataType originalSourceType;
                Transformer transformer = transformers.get(index);
                if (transformer.isSourceDataTypeSupported(originalSourceType = DataType.fromType(srcCls = result.getPayload().getDataType().getType()))) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Using " + String.valueOf(transformer) + " to transform payload.");
                    }
                    result = this.transformMessage(result, event, transformer);
                    continue;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Transformer " + String.valueOf(transformer) + " doesn't support the source payload: " + String.valueOf(srcCls));
                }
                if (this.canSkipTransformer(result, transformers, index)) continue;
                Transformer implicitTransformer = this.dataTypeConversionResolver.resolve(originalSourceType, transformer.getSourceDataTypes());
                if (implicitTransformer != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Performing implicit transformation with: " + String.valueOf(transformer));
                    }
                    result = this.transformMessage(result, event, implicitTransformer);
                    result = this.transformMessage(result, event, transformer);
                    continue;
                }
                throw new IllegalArgumentException("Cannot apply transformer " + String.valueOf(transformer) + " on source payload: " + String.valueOf(srcCls));
            }
            Transformer lastTransformer = transformers.get(transformers.size() - 1);
            DataType returnDataType = lastTransformer.getReturnDataType();
            this.checkResultDataType(message, returnDataType, result.getPayload().getValue());
        }
        return result;
    }

    private boolean canSkipTransformer(Message message, List<? extends Transformer> transformers, int index) {
        Transformer transformer = transformers.get(index);
        boolean skipConverter = false;
        if (transformer instanceof Converter) {
            if (index == transformers.size() - 1) {
                try {
                    TransformerUtils.checkTransformerReturnClass(transformer, message.getPayload().getValue());
                    skipConverter = true;
                }
                catch (TransformerException transformerException) {}
            } else {
                skipConverter = true;
            }
        }
        if (skipConverter) {
            logger.debug("Skipping converter: " + String.valueOf(transformer));
        }
        return skipConverter;
    }

    private Message transformMessage(Message message, CoreEvent event, Transformer transformer) throws MessageTransformerException, TransformerException {
        Object result = transformer.transform(message);
        if (result instanceof Message) {
            return (Message)result;
        }
        Message messagePostTransform = event != null && event.getMessage() != null ? event.getMessage() : message;
        return Message.builder(messagePostTransform).value(result).mediaType(this.mergeMediaType(messagePostTransform, transformer.getReturnDataType())).build();
    }

    private MediaType mergeMediaType(Message message, DataType transformed) {
        DataType original = message.getPayload().getDataType();
        MediaType mimeType = MediaType.ANY.matches(transformed.getMediaType()) ? original.getMediaType() : transformed.getMediaType();
        Charset encoding = transformed.getMediaType().getCharset().orElse(message.getPayload().getDataType().getMediaType().getCharset().orElse(this.getArtifactEncoding().getDefaultEncoding()));
        return DataType.builder().mediaType(mimeType).charset(encoding).build().getMediaType();
    }

    @Inject
    public void setDataTypeConversionResolver(DataTypeConversionResolver dataTypeConversionResolver) {
        this.dataTypeConversionResolver = dataTypeConversionResolver;
    }
}

