/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.alg.connectivity.ConnectivityInspector;
import org.jgrapht.graph.DefaultDirectedGraph;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.config.internal.BeanWrapper;
import org.mule.runtime.config.internal.resolvers.DependencyGraphBeanDependencyResolver;
import org.mule.runtime.core.internal.lifecycle.phases.LifecycleObjectSorter;

public class DependencyGraphLifecycleObjectSorter
implements LifecycleObjectSorter {
    private List<DefaultDirectedGraph<BeanWrapper, DefaultEdge>> dependencyGraphs;
    private List<DefaultDirectedGraph<BeanWrapper, DefaultEdge>> reverseGraphs;
    private DependencyGraphBeanDependencyResolver resolver;
    protected final Class<?>[] orderedLifecycleTypes;
    private Map<String, Integer> lifecycleObjectNameOrderMap;

    public DependencyGraphLifecycleObjectSorter(DependencyGraphBeanDependencyResolver resolver, Class<?>[] orderedLifecycleTypes) {
        this.dependencyGraphs = new ArrayList<DefaultDirectedGraph<BeanWrapper, DefaultEdge>>(orderedLifecycleTypes.length);
        this.reverseGraphs = new ArrayList<DefaultDirectedGraph<BeanWrapper, DefaultEdge>>(orderedLifecycleTypes.length);
        this.resolver = resolver;
        this.orderedLifecycleTypes = orderedLifecycleTypes;
        for (int i = 0; i < orderedLifecycleTypes.length; ++i) {
            DefaultDirectedGraph graph = new DefaultDirectedGraph(DefaultEdge.class);
            this.dependencyGraphs.add((DefaultDirectedGraph<BeanWrapper, DefaultEdge>)graph);
            DefaultDirectedGraph reverseGraph = new DefaultDirectedGraph(DefaultEdge.class);
            this.reverseGraphs.add((DefaultDirectedGraph<BeanWrapper, DefaultEdge>)reverseGraph);
        }
        this.lifecycleObjectNameOrderMap = new HashMap<String, Integer>();
    }

    @Override
    public void addObject(String beanName, Object currentObject) {
        Objects.requireNonNull(currentObject, "currentObject cannot be null");
        if (Arrays.stream(this.orderedLifecycleTypes).noneMatch(x -> x.isInstance(currentObject))) {
            return;
        }
        int graphIndex = this.getDependencyGraphIndex(currentObject);
        DefaultDirectedGraph<BeanWrapper, DefaultEdge> dependencyGraph = this.getDependencyGraphForLifecycleType(graphIndex);
        DefaultDirectedGraph<BeanWrapper, DefaultEdge> reverseGraph = this.getReverseGraphForLifecycleType(graphIndex);
        ConnectivityInspector pathInspector = new ConnectivityInspector(reverseGraph);
        BeanWrapper currentVertex = new BeanWrapper(beanName, currentObject);
        dependencyGraph.addVertex((Object)currentVertex);
        reverseGraph.addVertex((Object)currentVertex);
        Map<BeanWrapper, List<BeanWrapper>> prerequisiteObjectsMap = this.resolver.getTransitiveDependencies(beanName, graphIndex);
        for (BeanWrapper source : prerequisiteObjectsMap.keySet()) {
            List<BeanWrapper> prerequisiteObjects = prerequisiteObjectsMap.get(source);
            BeanWrapper current = new BeanWrapper(source.getName(), source.getWrappedObject());
            dependencyGraph.addVertex((Object)current);
            reverseGraph.addVertex((Object)current);
            if (prerequisiteObjects.isEmpty()) continue;
            prerequisiteObjects.forEach(prerequisite -> {
                String preReqName = prerequisite.getName();
                Object preReqObject = prerequisite.getWrappedObject();
                BeanWrapper preReqVertex = new BeanWrapper(preReqName, preReqObject);
                dependencyGraph.addVertex((Object)preReqVertex);
                reverseGraph.addVertex((Object)preReqVertex);
                if (!pathInspector.pathExists((Object)current, (Object)preReqVertex)) {
                    reverseGraph.addEdge((Object)preReqVertex, (Object)current);
                    dependencyGraph.addEdge((Object)current, (Object)preReqVertex);
                }
            });
        }
    }

    private int getDependencyGraphIndex(Object currentObject) {
        for (int index = 0; index < this.orderedLifecycleTypes.length; ++index) {
            if (!this.orderedLifecycleTypes[index].isInstance(currentObject)) continue;
            return index;
        }
        return this.orderedLifecycleTypes.length - 1;
    }

    private DefaultDirectedGraph<BeanWrapper, DefaultEdge> getDependencyGraphForLifecycleType(int graphIndex) {
        return this.dependencyGraphs.get(graphIndex);
    }

    private DefaultDirectedGraph<BeanWrapper, DefaultEdge> getReverseGraphForLifecycleType(int graphIndex) {
        return this.reverseGraphs.get(graphIndex);
    }

    @Override
    public List<Object> getSortedObjects() {
        List res = this.dependencyGraphs.stream().map(graph -> {
            ArrayList sortedObjects = Lists.newArrayList((Iterator)new TopologicalOrderIterator((Graph)graph, (o1, o2) -> {
                if (this.getLifeCycleObjectNameOrder().getOrDefault(o1.getName(), -1) > this.getLifeCycleObjectNameOrder().getOrDefault(o2.getName(), -1)) {
                    return -1;
                }
                return 1;
            }));
            Collections.reverse(sortedObjects);
            return sortedObjects;
        }).reduce(new ArrayList(), (sortedObjectList, b) -> {
            for (BeanWrapper v : b) {
                if (sortedObjectList.contains(v)) continue;
                sortedObjectList.add(v);
            }
            return sortedObjectList;
        });
        return res.stream().map(BeanWrapper::getWrappedObject).collect(Collectors.toList());
    }

    @Override
    public void setLifeCycleObjectNameOrder(List<String> lookupObjects) {
        int index = 0;
        for (String objectName : lookupObjects) {
            this.lifecycleObjectNameOrderMap.put(objectName, index++);
        }
    }

    private Map<String, Integer> getLifeCycleObjectNameOrder() {
        return this.lifecycleObjectNameOrderMap;
    }
}

