/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.client;

import java.util.function.Consumer;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.Http1ProtocolConfig;
import org.mule.runtime.http.api.Http2ProtocolConfig;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.runtime.http.api.tcp.TcpClientSocketProperties;
import org.mule.runtime.http.api.tcp.TcpClientSocketPropertiesBuilder;
import org.mule.runtime.http.support.internal.client.ProxyConfigImpl;
import org.mule.runtime.http.support.internal.client.TcpSocketPropertiesConfigurerToBuilder;
import org.mule.runtime.http.support.internal.protocol.Http1ProtocolConfigurerImpl;
import org.mule.runtime.http.support.internal.protocol.Http2ProtocolConfigurerImpl;
import org.mule.sdk.api.http.client.HttpClientConfigurer;
import org.mule.sdk.api.http.client.proxy.ProxyConfigurer;
import org.mule.sdk.api.http.protocol.Http1ProtocolConfigurer;
import org.mule.sdk.api.http.protocol.Http2ProtocolConfigurer;
import org.mule.sdk.api.http.tcp.TcpSocketPropertiesConfigurer;

public record HttpClientConfigToBuilder(HttpClientConfiguration.Builder builder) implements HttpClientConfigurer
{
    @Override
    public HttpClientConfigurer setTlsContextFactory(TlsContextFactory tlsContextFactory) {
        this.builder.setTlsContextFactory(tlsContextFactory);
        return this;
    }

    @Override
    public HttpClientConfigurer setMaxConnections(int maxConnections) {
        this.builder.setMaxConnections(maxConnections);
        return this;
    }

    @Override
    public HttpClientConfigurer setUsePersistentConnections(boolean usePersistentConnections) {
        this.builder.setUsePersistentConnections(usePersistentConnections);
        return this;
    }

    @Override
    public HttpClientConfigurer setConnectionIdleTimeout(int connectionIdleTimeout) {
        this.builder.setConnectionIdleTimeout(connectionIdleTimeout);
        return this;
    }

    @Override
    public HttpClientConfigurer setStreaming(boolean streaming) {
        this.builder.setStreaming(streaming);
        return this;
    }

    @Override
    public HttpClientConfigurer setResponseBufferSize(int responseBufferSize) {
        this.builder.setResponseBufferSize(responseBufferSize);
        return this;
    }

    @Override
    public HttpClientConfigurer setName(String name) {
        this.builder.setName(name);
        return this;
    }

    @Override
    public HttpClientConfigurer setDecompress(Boolean decompress) {
        this.builder.setDecompress(decompress);
        return this;
    }

    @Override
    public HttpClientConfigurer configClientSocketProperties(Consumer<TcpSocketPropertiesConfigurer> configCallback) {
        TcpClientSocketPropertiesBuilder propsBuilder = TcpClientSocketProperties.builder();
        TcpSocketPropertiesConfigurerToBuilder configurer = new TcpSocketPropertiesConfigurerToBuilder(propsBuilder);
        configCallback.accept(configurer);
        this.builder.setClientSocketProperties(propsBuilder.build());
        return this;
    }

    @Override
    public HttpClientConfigurer configProxy(Consumer<ProxyConfigurer> configCallback) {
        ProxyConfigImpl configurer = new ProxyConfigImpl();
        configCallback.accept(configurer);
        this.builder.setProxyConfig(configurer.build());
        return this;
    }

    @Override
    public HttpClientConfigurer configHttp1(Consumer<Http1ProtocolConfigurer> configCallback) {
        Http1ProtocolConfig config = new Http1ProtocolConfig(true);
        configCallback.accept(new Http1ProtocolConfigurerImpl(config));
        this.builder.setHttp1Config(config);
        return this;
    }

    @Override
    public HttpClientConfigurer configHttp2(Consumer<Http2ProtocolConfigurer> configCallback) {
        Http2ProtocolConfig config = new Http2ProtocolConfig(true);
        configCallback.accept(new Http2ProtocolConfigurerImpl(config));
        this.builder.setHttp2Config(config);
        return this;
    }
}

