/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.util;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.CharUtils;

public class StringUtils {
    public static final String WHITE_SPACE = " ";
    public static final String DASH = "-";
    @Deprecated(since="4.10", forRemoval=true)
    public static final String EMPTY = "";
    private static final String HEX_CHARACTERS = "0123456789abcdef";
    private static final String HEX_CHARACTERS_UC = "0123456789abcdef".toUpperCase();

    @Deprecated(since="4.10", forRemoval=true)
    public static String[] splitAndTrim(String string, String delim) {
        if (string == null) {
            return null;
        }
        if (StringUtils.isEmpty(string)) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        String[] rawTokens = org.apache.commons.lang3.StringUtils.split((String)string, (String)delim);
        ArrayList<String> tokens = new ArrayList<String>();
        if (rawTokens != null) {
            for (String rawToken : rawTokens) {
                String token = StringUtils.trim(rawToken);
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)token)) continue;
                tokens.add(token);
            }
        }
        return (String[])tokens.stream().toArray(String[]::new);
    }

    public static byte[] hexStringToByteArray(String hex) {
        if (hex == null) {
            return null;
        }
        int stringLength = hex.length();
        if (stringLength % 2 != 0) {
            throw new IllegalArgumentException("Hex String must have even number of characters!");
        }
        byte[] result = new byte[stringLength / 2];
        int j = 0;
        for (int i = 0; i < result.length; ++i) {
            char hi = Character.toLowerCase(hex.charAt(j++));
            char lo = Character.toLowerCase(hex.charAt(j++));
            result[i] = (byte)(Character.digit(hi, 16) << 4 | Character.digit(lo, 16));
        }
        return result;
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static String repeat(char c, int len) {
        return org.apache.commons.lang3.StringUtils.repeat((String)CharUtils.toString((char)c), (int)len);
    }

    @Deprecated(forRemoval=true, since="4.10")
    public static String toHexString(byte[] bytes) {
        return StringUtils.toHexString(bytes, false);
    }

    @Deprecated(forRemoval=true, since="4.10")
    public static String toHexString(byte[] bytes, boolean uppercase) {
        if (bytes == null) {
            return null;
        }
        int numBytes = bytes.length;
        StringBuilder str = new StringBuilder(numBytes * 2);
        String table = uppercase ? HEX_CHARACTERS_UC : HEX_CHARACTERS;
        for (int i = 0; i < numBytes; ++i) {
            str.append(table.charAt(bytes[i] >>> 4 & 0xF));
            str.append(table.charAt(bytes[i] & 0xF));
        }
        return str.toString();
    }

    public static String match(Pattern pattern, String value, int matchIndex) throws IllegalArgumentException {
        if (value == null || pattern == null) {
            throw new IllegalArgumentException("pattern and value cannot be null");
        }
        Matcher matcher = pattern.matcher(value);
        if (matcher.find() && matcher.groupCount() >= matchIndex) {
            return matcher.group(matchIndex);
        }
        return null;
    }

    public static void ifNotBlank(String value, Consumer<String> consumer) {
        if (!StringUtils.isBlank(value)) {
            consumer.accept(value);
        }
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static boolean isEmpty(String str) {
        return org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)str);
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static boolean isBlank(String str) {
        return org.apache.commons.lang3.StringUtils.isBlank((CharSequence)str);
    }

    @Deprecated(since="4.10", forRemoval=true)
    public static String trim(String str) {
        return org.apache.commons.lang3.StringUtils.trim((String)str);
    }

    public static String sanitizeUrl(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private StringUtils() {
    }
}

