/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.span.command;

import org.mule.runtime.api.profiling.tracing.Span;
import org.mule.runtime.api.profiling.tracing.SpanIdentifier;
import org.slf4j.MDC;

public class SpanMDCUtils {
    public static final String SPAN_ID_MDC_KEY = "span_id";
    public static final String TRACE_ID_MDC_KEY = "trace_id";
    public static final String TRACE_FLAGS_MDC_KEY = "trace_flags";
    private static final String TRACE_FLAGS_DEFAULT_HEX_VALUE = "01";

    private SpanMDCUtils() {
    }

    public static void setCurrentTracingInformationToMdc(Span span) {
        SpanIdentifier spanIdentifier = span.getIdentifier();
        if (spanIdentifier != null && spanIdentifier.isValid()) {
            MDC.put((String)SPAN_ID_MDC_KEY, (String)spanIdentifier.getId());
            MDC.put((String)TRACE_ID_MDC_KEY, (String)spanIdentifier.getTraceId());
            MDC.put((String)TRACE_FLAGS_MDC_KEY, (String)TRACE_FLAGS_DEFAULT_HEX_VALUE);
        }
    }

    public static void removeCurrentTracingInformationFromMdc() {
        MDC.remove((String)SPAN_ID_MDC_KEY);
        MDC.remove((String)TRACE_ID_MDC_KEY);
    }
}

