/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.type.context.ComponentProcessingStrategyProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.util.context.Context;

public interface ReactorPublisherBuilder<T extends Publisher> {
    public static ReactorPublisherBuilder<Mono<CoreEvent>> buildMono(CoreEvent event) {
        return new MonoBuilder((Mono<CoreEvent>)Mono.just((Object)event));
    }

    public static ReactorPublisherBuilder<Flux<CoreEvent>> buildFlux(Publisher<CoreEvent> publisher) {
        return new FluxBuilder((Flux<CoreEvent>)Flux.from(publisher));
    }

    public ReactorPublisherBuilder<T> doOnNext(Consumer<CoreEvent> var1);

    public ReactorPublisherBuilder<T> publishOn(Optional<ScheduledExecutorService> var1);

    public ReactorPublisherBuilder<T> transform(ReactiveProcessor var1);

    public ReactorPublisherBuilder<T> subscriberContext(Function<Context, Context> var1);

    public ReactorPublisherBuilder<T> doOnSubscribe(Consumer<? super Subscription> var1);

    public ReactorPublisherBuilder<T> profileProcessingStrategyEvent(InternalProfilingService var1, ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> var2, Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> var3);

    public ReactorPublisherBuilder<T> setTracingContext(InternalProfilingService var1, Function<CoreEvent, ExecutionContext> var2);

    public T build();

    public static class MonoBuilder
    implements ReactorPublisherBuilder<Mono<CoreEvent>> {
        Mono<CoreEvent> mono;

        private MonoBuilder(Mono<CoreEvent> mono) {
            this.mono = mono;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> doOnNext(Consumer<CoreEvent> onNext) {
            this.mono = this.mono.doOnNext(onNext);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> publishOn(Optional<ScheduledExecutorService> scheduler) {
            this.mono = scheduler.map(sch -> this.mono.publishOn(Schedulers.fromExecutorService((ExecutorService)sch))).orElse(this.mono);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> transform(ReactiveProcessor processor) {
            this.mono = this.mono.transform((Function)processor);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> subscriberContext(Function<Context, Context> function) {
            this.mono = this.mono.contextWrite(function);
            return this;
        }

        @Override
        public Mono<CoreEvent> build() {
            return this.mono;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
            this.mono = this.mono.doOnSubscribe(onSubscribe);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> profileProcessingStrategyEvent(InternalProfilingService profilingService, ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> dataProducer, Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transformer) {
            this.mono = profilingService.enrichWithProfilingEventMono(this.mono, dataProducer, transformer);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Mono<CoreEvent>> setTracingContext(InternalProfilingService profilingService, Function<CoreEvent, ExecutionContext> executionContextSupplier) {
            this.mono = profilingService.setCurrentExecutionContext(this.mono, executionContextSupplier);
            return this;
        }
    }

    public static class FluxBuilder
    implements ReactorPublisherBuilder<Flux<CoreEvent>> {
        Flux<CoreEvent> flux;

        private FluxBuilder(Flux<CoreEvent> flux) {
            this.flux = flux;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> doOnNext(Consumer<CoreEvent> onNext) {
            this.flux = this.flux.doOnNext(onNext);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> publishOn(Optional<ScheduledExecutorService> scheduler) {
            this.flux = scheduler.map(sch -> this.flux.publishOn(Schedulers.fromExecutorService((ExecutorService)sch))).orElse(this.flux);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> transform(ReactiveProcessor processor) {
            this.flux = this.flux.transform((Function)processor);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> subscriberContext(Function<Context, Context> function) {
            this.flux = this.flux.contextWrite(function);
            return this;
        }

        @Override
        public Flux<CoreEvent> build() {
            return this.flux;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> doOnSubscribe(Consumer<? super Subscription> onSubscribe) {
            this.flux = this.flux.doOnSubscribe(onSubscribe);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> profileProcessingStrategyEvent(InternalProfilingService profilingService, ProfilingDataProducer<ComponentProcessingStrategyProfilingEventContext, CoreEvent> dataProducer, Function<CoreEvent, ComponentProcessingStrategyProfilingEventContext> transformer) {
            this.flux = profilingService.enrichWithProfilingEventFlux(this.flux, dataProducer, transformer);
            return this;
        }

        @Override
        public ReactorPublisherBuilder<Flux<CoreEvent>> setTracingContext(InternalProfilingService profilingService, Function<CoreEvent, ExecutionContext> executionContextSupplier) {
            this.flux = profilingService.setCurrentExecutionContext(this.flux, executionContextSupplier);
            return this;
        }
    }
}

