/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.event;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.event.EventContextService;
import org.mule.runtime.core.internal.event.DefaultEventContext;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;

public class DefaultEventContextService
implements EventContextService {
    private final Set<DefaultEventContext> currentContexts = ConcurrentHashMap.newKeySet(512);
    private final ConcurrentHashMap<String, Instant> droppedEvents = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Instant> droppedErrors = new ConcurrentHashMap();

    @Override
    public List<EventContextService.FlowStackEntry> getCurrentlyActiveFlowStacks() {
        Instant now = Instant.now();
        ArrayList<EventContextService.FlowStackEntry> flowStacks = new ArrayList<EventContextService.FlowStackEntry>();
        for (DefaultEventContext context : this.currentContexts) {
            flowStacks.add(new DefaultFlowStackEntry(context, now, this.droppedEvents.get(context.getId()), this.droppedErrors.get(context.getId())));
            context.forEachChild(childContext -> flowStacks.add(new DefaultFlowStackEntry((BaseEventContext)childContext, now, this.droppedEvents.get(childContext.getId()), this.droppedErrors.get(childContext.getId()))));
        }
        return flowStacks;
    }

    public void addContext(DefaultEventContext context) {
        this.currentContexts.add(context);
    }

    public void removeContext(DefaultEventContext context) {
        this.currentContexts.remove(context);
    }

    @Override
    public Set<String> getDroppedEventIds() {
        return this.droppedEvents.keySet();
    }

    @Override
    public Set<String> getDroppedErrorIds() {
        return this.droppedErrors.keySet();
    }

    public void recordDroppedEvent(String eventId) {
        this.droppedEvents.put(eventId, Instant.now());
    }

    public void recordDroppedError(String eventId) {
        this.droppedErrors.put(eventId, Instant.now());
    }

    public void recordDroppedError(Throwable error) {
        DefaultEventContextService.extractEventIdFromError(error).ifPresent(this::recordDroppedError);
    }

    private static Optional<String> extractEventIdFromError(Throwable error) {
        if (error instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)error;
            return Optional.of(messagingException.getEvent().getContext().getId());
        }
        Throwable cause = error.getCause();
        if (cause instanceof MessagingException) {
            MessagingException messagingException = (MessagingException)cause;
            return Optional.of(messagingException.getEvent().getContext().getId());
        }
        return Optional.empty();
    }

    private static final class DefaultFlowStackEntry
    implements EventContextService.FlowStackEntry {
        private final String serverId;
        private final String parentEventId;
        private final String eventId;
        private final EventContextService.EventContextState state;
        private final Duration executingTime;
        private final String originatingLocation;
        private final FlowCallStack flowCallStack;
        private final Instant droppedAt;
        private final Instant droppedErrorAt;

        public DefaultFlowStackEntry(BaseEventContext context, Instant now, Instant droppedAt, Instant droppedErrorAt) {
            this.serverId = context.getServerId();
            this.parentEventId = context.getParentContext().map(EventContext::getId).orElse(null);
            this.eventId = context.getId();
            this.state = context.isTerminated() ? EventContextService.EventContextState.TERMINATED : (context.isComplete() ? EventContextService.EventContextState.COMPLETE : (context.isResponseDone() ? EventContextService.EventContextState.RESPONSE_PROCESSED : EventContextService.EventContextState.EXECUTING));
            this.executingTime = Duration.between(context.getStartTime(), now);
            this.originatingLocation = context.getOriginatingLocation().getLocation();
            this.flowCallStack = context.getFlowCallStack().clone();
            this.droppedAt = droppedAt;
            this.droppedErrorAt = droppedErrorAt;
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getParentEventId() {
            return this.parentEventId;
        }

        @Override
        public String getEventId() {
            return this.eventId;
        }

        @Override
        public EventContextService.EventContextState getState() {
            return this.state;
        }

        @Override
        public Duration getExecutingTime() {
            return this.executingTime;
        }

        @Override
        public FlowCallStack getFlowCallStack() {
            return this.flowCallStack;
        }

        @Override
        public Optional<Instant> getDroppedAt() {
            return Optional.ofNullable(this.droppedAt);
        }

        @Override
        public Optional<Instant> getDroppedErrorAt() {
            return Optional.ofNullable(this.droppedErrorAt);
        }

        public String toString() {
            return "eventId: " + this.eventId + " @ " + this.originatingLocation + ";" + System.lineSeparator() + this.getFlowCallStack().toString();
        }
    }
}

