/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.util.queue.wrapper;

import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.queue.DefaultQueueConfiguration;
import org.mule.runtime.api.queue.QueueManager;
import org.mule.runtime.core.api.util.queue.QueueConfiguration;
import org.mule.runtime.core.api.util.queue.QueueSession;
import org.mule.runtime.core.internal.util.queue.wrapper.QueueSessionWrapper;

public class QueueManagerWrapper
implements org.mule.runtime.core.api.util.queue.QueueManager {
    private QueueManager delegate;

    @Inject
    @Named(value="_muleApiQueueManager")
    public void setQueueManager(QueueManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public QueueSession getQueueSession() {
        return new QueueSessionWrapper(this.delegate.getQueueSession());
    }

    @Override
    public void setDefaultQueueConfiguration(QueueConfiguration config) {
        this.delegate.setDefaultQueueConfiguration(new DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public void setQueueConfiguration(String queueName, QueueConfiguration config) {
        this.delegate.setQueueConfiguration(queueName, new DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public Optional<QueueConfiguration> getQueueConfiguration(String queueName) {
        return this.delegate.getQueueConfiguration(queueName).map(config -> new org.mule.runtime.core.api.util.queue.DefaultQueueConfiguration(config.getCapacity(), config.isPersistent()));
    }

    @Override
    public void start() throws MuleException {
        this.delegate.start();
    }

    @Override
    public void stop() throws MuleException {
        this.delegate.stop();
    }
}

