/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.rx.Exceptions;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.exception.SdkMethodInvocationException;
import org.mule.runtime.module.extension.internal.runtime.execution.GeneratedMethodComponentExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.OperationArgumentResolverFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractCompletableMethodOperationExecutor<M extends ComponentModel>
implements CompletableComponentExecutor<M>,
OperationArgumentResolverFactory<M>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractCompletableMethodOperationExecutor.class);
    protected final GeneratedMethodComponentExecutor<M> executor;
    @Inject
    private MuleContext muleContext;

    public AbstractCompletableMethodOperationExecutor(M operationModel, Method operationMethod, Object operationInstance) {
        this.executor = new GeneratedMethodComponentExecutor(operationModel.getParameterGroupModels(), operationMethod, operationInstance);
    }

    @Override
    public final void execute(ExecutionContext<M> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
        try {
            this.doExecute(executionContext, callback);
        }
        catch (SdkMethodInvocationException e) {
            this.handleError(Exceptions.wrapFatal(e.getCause()), (ExecutionContextAdapter)executionContext, callback);
        }
        catch (Exception e) {
            this.handleError(e, (ExecutionContextAdapter)executionContext, callback);
        }
        catch (Throwable t) {
            this.handleError(Exceptions.wrapFatal(t), (ExecutionContextAdapter)executionContext, callback);
        }
    }

    protected abstract void doExecute(ExecutionContext<M> var1, CompletableComponentExecutor.ExecutorCallback var2);

    protected void handleError(Throwable t, ExecutionContextAdapter<M> executionContext, CompletableComponentExecutor.ExecutorCallback callback) {
        CompletionCallback completionCallback = (CompletionCallback)executionContext.getVariable("MULE_COMPLETION_CALLBACK_CONTEXT_PARAM");
        if (completionCallback != null) {
            if (t instanceof Exception) {
                completionCallback.error(t);
            } else {
                completionCallback.error(new MuleRuntimeException(t));
            }
        } else {
            callback.error(t);
        }
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.executor, true, this.muleContext);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.executor);
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.executor);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.executor, LOGGER);
    }

    @Override
    public Function<ExecutionContext<M>, Map<String, Object>> createArgumentResolver(M operationModel) {
        return this.executor instanceof OperationArgumentResolverFactory ? this.executor.createArgumentResolver(operationModel) : ec -> Collections.emptyMap();
    }
}

