/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.consumer;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import java.util.Set;
import java.util.function.Predicate;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.core.internal.profiling.consumer.ComponentProfilingUtils;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RuntimeInternalProfilingDataConsumer
public class LoggerComponentThreadingDataConsumer
implements ProfilingDataConsumer<ComponentThreadingProfilingEventContext> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggerComponentThreadingDataConsumer.class);
    private final Gson gson = new Gson();

    @Override
    public void onProfilingEvent(ProfilingEventType<ComponentThreadingProfilingEventContext> profilingEventType, ComponentThreadingProfilingEventContext profilingEventContext) {
        Logger logger = this.getDataConsumerLogger();
        if (logger.isDebugEnabled()) {
            logger.debug(this.gson.toJson(ComponentProfilingUtils.getComponentThreadingInfoMap(profilingEventType, profilingEventContext)));
        }
    }

    @Override
    public Set<ProfilingEventType<ComponentThreadingProfilingEventContext>> getProfilingEventTypes() {
        return ImmutableSet.of(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION, RuntimeProfilingEventTypes.OPERATION_THREAD_RELEASE, RuntimeProfilingEventTypes.OPERATION_EXECUTED);
    }

    @Override
    public Predicate<ComponentThreadingProfilingEventContext> getEventContextFilter() {
        return profilingEventContext -> true;
    }

    protected Logger getDataConsumerLogger() {
        return LOGGER;
    }
}

