/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import jakarta.inject.Inject;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.util.func.Once;
import org.mule.runtime.core.internal.util.ClassUtils;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class InlineParameterGroupObjectFactory
extends AbstractExtensionObjectFactory<Object> {
    @Inject
    private ReflectionCache reflectionCache;
    private DefaultObjectBuilder builder;
    private Class<Object> objectClass;
    private final ObjectType objectType;
    private final ClassLoader classLoader;
    private final Once.RunOnce initialiser;

    public InlineParameterGroupObjectFactory(ObjectType type, ClassLoader classLoader, MuleContext muleContext) {
        super(muleContext);
        this.classLoader = classLoader;
        this.objectType = type;
        this.initialiser = Once.of(() -> {
            this.objectClass = JavaTypeUtils.getType(type);
            this.builder = new DefaultObjectBuilder<Object>(this.objectClass, this.reflectionCache);
        });
    }

    @Override
    public Object doGetObject() throws Exception {
        return ClassUtils.withContextClassLoader(this.classLoader, () -> {
            this.initialiser.runOnce();
            this.resolveParameters(this.objectType, this.builder);
            this.resolveParameterGroups(this.objectType, this.builder);
            return new ObjectBuilderValueResolver(this.builder, this.muleContext);
        }, Exception.class, exception -> {
            throw exception;
        });
    }
}

