/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validator;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.StringType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.api.meta.model.ConnectableComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.FieldsValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ValueProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.value.ValueProviderUtils;

public abstract class AbstractValueProviderModelValidator<C extends ValidationContext>
implements ExtensionModelValidator {
    public void doValidate(ExtensionModel model, final ProblemsReporter problemsReporter, C validationContext) {
        new IdempotentExtensionWalker((ValidationContext)validationContext){
            final /* synthetic */ ValidationContext val$validationContext;
            {
                this.val$validationContext = validationContext;
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                AbstractValueProviderModelValidator.this.doValidateModel(model, problemsReporter, this.val$validationContext, false);
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                AbstractValueProviderModelValidator.this.doValidateModel(model, problemsReporter, this.val$validationContext, false);
            }

            @Override
            protected void onSource(SourceModel model) {
                AbstractValueProviderModelValidator.this.doValidateModel(model, problemsReporter, this.val$validationContext, true);
            }

            @Override
            protected void onOperation(OperationModel model) {
                AbstractValueProviderModelValidator.this.doValidateModel(model, problemsReporter, this.val$validationContext, true);
            }
        }.walk(model);
    }

    private void doValidateModel(ParameterizedModel model, ProblemsReporter problemsReporter, C validationContext, boolean supportsConnectionsAndConfigs) {
        model.getAllParameterModels().forEach(param -> {
            Optional<ValueProviderFactoryModelProperty> valueProviderFactoryModelProperty = param.getModelProperty(ValueProviderFactoryModelProperty.class);
            Optional<FieldsValueProviderFactoryModelProperty> fieldValueProviderFactoryModelProperty = param.getModelProperty(FieldsValueProviderFactoryModelProperty.class);
            if (valueProviderFactoryModelProperty.isPresent() && fieldValueProviderFactoryModelProperty.isPresent()) {
                problemsReporter.addError(new Problem(model, String.format("Parameter [%s] from %s with name %s has both a Value Provider and a Field Value Provider", param.getName(), NameUtils.getComponentModelTypeName(model), NameUtils.getModelName(model))));
            } else if (valueProviderFactoryModelProperty.isPresent()) {
                this.validateOptionsResolver((ParameterModel)param, true, null, valueProviderFactoryModelProperty.get(), model, problemsReporter, validationContext, supportsConnectionsAndConfigs);
            } else {
                fieldValueProviderFactoryModelProperty.map(FieldsValueProviderFactoryModelProperty::getFieldsValueProviderFactories).ifPresent(factories -> factories.forEach((targetSelector, fieldsValueProviderFactoryModelProperty) -> this.validateOptionsResolver((ParameterModel)param, false, (String)targetSelector, (ValueProviderFactoryModelProperty)fieldsValueProviderFactoryModelProperty, model, problemsReporter, validationContext, supportsConnectionsAndConfigs)));
            }
        });
    }

    private void validateOptionsResolver(ParameterModel param, boolean mustBeStringType, String targetSelector, ValueProviderFactoryModelProperty modelProperty, ParameterizedModel model, ProblemsReporter problemsReporter, C validationContext, boolean supportsConnectionsAndConfigs) {
        Optional<ValueProviderModel> valueProviderModel = targetSelector != null ? param.getFieldValueProviderModels().stream().filter(fieldValueProviderModel -> fieldValueProviderModel.getTargetSelector().equals(targetSelector)).findAny() : param.getValueProviderModel();
        if (valueProviderModel.isEmpty()) {
            throw new IllegalStateException(String.format("Parameter %s from %s with name %s has should have a ValueProviderModel associated.", param.getName(), NameUtils.getComponentModelTypeName(model), NameUtils.getModelName(model)));
        }
        List<ParameterModel> allContainerParameters = model.getAllParameterModels();
        this.doValidateProvider(model, modelProperty, valueProviderModel.get(), problemsReporter, validationContext);
        if (this.validateComponentHasParametersWithRepeatedNames(allContainerParameters, param, problemsReporter, model)) {
            return;
        }
        Map<String, MetadataType> containerParameterTypesByName = allContainerParameters.stream().collect(Collectors.toMap(NamedObject::getName, Typed::getType));
        String modelName = NameUtils.getModelName(model);
        String modelTypeName = NameUtils.getComponentModelTypeName(model);
        if (mustBeStringType && !(param.getType() instanceof StringType)) {
            problemsReporter.addError(new Problem(model, String.format("The parameter [%s] of the %s '%s' is not of String type. Parameters that provides Values should be of String type.", param.getName(), modelTypeName, modelName)));
        }
        String providerId = this.getProviderId(modelProperty, valueProviderModel.get());
        for (ActingParameterModel actingParameterModel : modelProperty.getActingParameterModels()) {
            String parameterNameFromExtractionExpression = ValueProviderUtils.getParameterNameFromExtractionExpression(actingParameterModel.getExtractionExpression());
            if (containerParameterTypesByName.containsKey(parameterNameFromExtractionExpression)) continue;
            problemsReporter.addError(new Problem(model, String.format("The Value Provider [%s] declares to use a parameter '%s' which doesn't exist in the %s '%s'", providerId, parameterNameFromExtractionExpression, modelTypeName, modelName)));
        }
        this.doValidateInjectableParameters(model, modelName, modelTypeName, containerParameterTypesByName, modelProperty, valueProviderModel.get(), problemsReporter, validationContext);
        this.reportProblems(model, problemsReporter, supportsConnectionsAndConfigs, valueProviderModel, modelName, modelTypeName, providerId);
    }

    private void reportProblems(ParameterizedModel model, ProblemsReporter problemsReporter, boolean supportsConnectionsAndConfigs, Optional<? extends ValueProviderModel> valueProviderModel, String modelName, String modelTypeName, String providerId) {
        ConnectableComponentModel connectableComponentModel;
        boolean usesConnection = valueProviderModel.get().requiresConnection();
        boolean usesConfig = valueProviderModel.get().requiresConfiguration();
        if (supportsConnectionsAndConfigs && usesConnection && model instanceof ConnectableComponentModel && (connectableComponentModel = (ConnectableComponentModel)model).requiresConnection() != usesConnection) {
            problemsReporter.addError(new Problem(model, String.format("The Value Provider [%s] defines that requires a connection, but is used in the %s '%s' which is connection less", providerId, modelTypeName, modelName)));
        }
        if (!supportsConnectionsAndConfigs) {
            if (usesConnection) {
                problemsReporter.addError(new Problem(model, String.format("The Value Provider [%s] defines that requires a connection which is not allowed for a Value Provider of a %s's parameter [%s]", providerId, modelTypeName, modelName)));
            }
            if (usesConfig) {
                problemsReporter.addError(new Problem(model, String.format("The Value Provider [%s] defines that requires a configuration which is not allowed for a Value Provider of a %s's parameter [%s]", providerId, modelTypeName, modelName)));
            }
        }
    }

    private boolean validateComponentHasParametersWithRepeatedNames(List<ParameterModel> allParameterModels, ParameterModel param, ProblemsReporter problemsReporter, ParameterizedModel parameterizedModel) {
        HashSet<String> repeatedParameterNames = new HashSet<String>();
        HashSet<String> parameterNames = new HashSet<String>();
        for (ParameterModel parameterModel : allParameterModels) {
            if (parameterNames.contains(parameterModel.getName())) {
                repeatedParameterNames.add(parameterModel.getName());
                continue;
            }
            parameterNames.add(parameterModel.getName());
        }
        if (!repeatedParameterNames.isEmpty()) {
            problemsReporter.addError(new Problem(param, String.format("Parameter [%s] from %s with name %s has a Value Provider defined, but that %s has one or more parameters with repeated names [%s]. Components with parameters with non-unique names do not support Value Providers", param.getName(), NameUtils.getComponentModelTypeName(parameterizedModel), parameterizedModel.getName(), NameUtils.getComponentModelTypeName(parameterizedModel), String.join((CharSequence)", ", repeatedParameterNames))));
            return true;
        }
        return false;
    }

    protected String getProviderId(ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel) {
        return valueProviderModel.getProviderId();
    }

    protected void doValidateProvider(ParameterizedModel containerModel, ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel, ProblemsReporter problemsReporter, C validationContext) {
    }

    protected void doValidateInjectableParameters(ParameterizedModel containerModel, String containerName, String containerTypeName, Map<String, MetadataType> containerParameterTypesByName, ValueProviderFactoryModelProperty modelProperty, ValueProviderModel valueProviderModel, ProblemsReporter problemsReporter, C validationContext) {
    }

    public static interface ValidationContext {
    }
}

