/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.context.notification;

import jakarta.inject.Inject;
import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleExceptionInfo;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.EnrichedNotificationInfo;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.api.notification.PipelineMessageNotification;
import org.mule.runtime.core.api.context.notification.FlowCallStack;
import org.mule.runtime.core.api.context.notification.FlowTraceManager;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.context.notification.FlowNotificationTextDebugger;
import org.mule.runtime.core.internal.context.notification.MessageProcessorTextDebugger;
import org.mule.runtime.core.internal.execution.LocationExecutionContextProvider;
import org.mule.runtime.core.privileged.event.DefaultFlowCallStack;

public class MessageProcessingFlowTraceManager
extends LocationExecutionContextProvider
implements FlowTraceManager,
Initialisable,
Disposable {
    public static final String FLOW_STACK_INFO_KEY = "FlowStack";
    private final FlowNotificationTextDebugger pipelineProcessorDebugger;
    private final MessageProcessorTextDebugger messageProcessorTextDebugger = new MessageProcessorTextDebugger(this);
    private ServerNotificationManager notificationManager;
    private volatile boolean listenersAdded = false;

    public MessageProcessingFlowTraceManager() {
        this.pipelineProcessorDebugger = new FlowNotificationTextDebugger(this);
    }

    @Override
    public void initialise() throws InitialisationException {
        this.handleNotificationListeners();
    }

    @Override
    public void dispose() {
        this.removeNotificationListeners();
    }

    protected synchronized void handleNotificationListeners() {
        if (!this.notificationManager.isDisposed() && !this.listenersAdded) {
            this.notificationManager.addListener(this.messageProcessorTextDebugger);
            this.notificationManager.addListener(this.pipelineProcessorDebugger);
            this.listenersAdded = true;
        }
    }

    protected synchronized void removeNotificationListeners() {
        if (this.listenersAdded && !this.notificationManager.isDisposed()) {
            this.notificationManager.removeListener(this.messageProcessorTextDebugger);
            this.notificationManager.removeListener(this.pipelineProcessorDebugger);
            this.listenersAdded = false;
        }
    }

    public void onMessageProcessorNotificationPreInvoke(MessageProcessorNotification notification) {
        FlowCallStack flowCallStack = ((CoreEvent)notification.getEvent()).getFlowCallStack();
        if (flowCallStack != null) {
            String representation = notification.getComponent().getRepresentation();
            ((DefaultFlowCallStack)flowCallStack).pushCurrentProcessorPath(representation, notification.getComponent().getLocation(), notification.getComponent().getAnnotations());
        }
    }

    public void onPipelineNotificationComplete(PipelineMessageNotification notification) {
        this.onFlowComplete(notification.getInfo());
    }

    public void onPipelineNotificationStart(PipelineMessageNotification notification) {
        this.onFlowStart(notification.getInfo(), notification.getResourceIdentifier());
    }

    @Override
    public void onFlowStart(EnrichedNotificationInfo notificationInfo, String flowName) {
    }

    @Override
    public void onFlowComplete(EnrichedNotificationInfo notificationInfo) {
    }

    @Override
    public Map<String, Object> getContextInfo(EnrichedNotificationInfo notificationInfo, Component lastProcessed) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.putIfAbsent(FLOW_STACK_INFO_KEY, ((CoreEvent)notificationInfo.getEvent()).getFlowCallStack().clone());
        return info;
    }

    @Override
    public void putContextInfo(MuleExceptionInfo info, EnrichedNotificationInfo notificationInfo, Component lastProcessed) {
        if (info.getFlowStack() == null) {
            info.setFlowStack(((CoreEvent)notificationInfo.getEvent()).getFlowCallStack().clone());
        }
    }

    @Inject
    public void setNotificationManager(ServerNotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }
}

