/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.value;

import java.util.Optional;
import java.util.function.Supplier;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactory;
import org.mule.runtime.extension.api.loader.parser.ValueProviderFactoryContext;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;
import org.mule.runtime.module.extension.api.runtime.resolver.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.ResolverBasedComponentParameterization;

public class ValueProviderFactoryWrapper {
    private final ValueProviderFactory valueProviderFactory;
    private final MuleContext muleContext;
    private final ValueProviderFactoryContext valueProviderFactoryContext;

    public ValueProviderFactoryWrapper(ValueProviderModel model, ValueProviderFactory valueProviderFactory, ParameterValueResolver parameterValueResolver, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier, MuleContext muleContext, ParameterizedModel parameterizedModel) {
        this.valueProviderFactory = valueProviderFactory;
        this.muleContext = muleContext;
        ResolverBasedComponentParameterization<ParameterizedModel> componentParameterization = new ResolverBasedComponentParameterization<ParameterizedModel>(parameterizedModel, parameterValueResolver);
        this.valueProviderFactoryContext = new DefaultValueProviderFactoryContext(model, componentParameterization, connectionSupplier, configurationSupplier);
        try {
            muleContext.getInjector().inject(valueProviderFactory);
        }
        catch (MuleException e) {
            throw new RuntimeException(e);
        }
    }

    ValueProvider createValueProvider() throws ValueResolvingException {
        try {
            ValueProvider valueProvider = this.valueProviderFactory.create(this.valueProviderFactoryContext);
            LifecycleUtils.initialiseIfNeeded((Object)valueProvider, this.muleContext);
            return valueProvider;
        }
        catch (ValueResolvingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ValueResolvingException("An error occurred trying to create a ValueProvider", "UNKNOWN", (Throwable)e);
        }
    }

    private static class DefaultValueProviderFactoryContext
    implements ValueProviderFactoryContext {
        private final ValueProviderModel valueProviderModel;
        private final ComponentParameterization<?> componentParameterization;
        private final Supplier<Object> connectionSupplier;
        private final Supplier<Object> configurationSupplier;

        private DefaultValueProviderFactoryContext(ValueProviderModel valueProviderModel, ComponentParameterization<?> componentParameterization, Supplier<Object> connectionSupplier, Supplier<Object> configurationSupplier) {
            this.valueProviderModel = valueProviderModel;
            this.componentParameterization = componentParameterization;
            this.connectionSupplier = connectionSupplier;
            this.configurationSupplier = configurationSupplier;
        }

        @Override
        public ValueProviderModel getModel() {
            return this.valueProviderModel;
        }

        @Override
        public ComponentParameterization<?> getComponentParameterization() {
            return this.componentParameterization;
        }

        @Override
        public Optional<Supplier<?>> getConfigurationSupplier() {
            return this.valueProviderModel.requiresConfiguration() ? Optional.of(this.configurationSupplier) : Optional.empty();
        }

        @Override
        public Optional<Supplier<?>> getConnectionSupplier() {
            return this.valueProviderModel.requiresConnection() ? Optional.of(this.connectionSupplier) : Optional.empty();
        }
    }
}

