/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.log4j.internal;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.selector.ContextSelector;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.util.MuleContainerUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DirectoryResourceLocator;
import org.mule.runtime.module.artifact.api.classloader.LocalResourceLocator;
import org.mule.runtime.module.artifact.api.descriptor.DeployableArtifactDescriptor;
import org.mule.runtime.module.log4j.internal.ArtifactAwareContextSelector;
import org.mule.runtime.module.log4j.internal.MuleLoggerContext;

public class MuleLoggerContextFactory {
    static final String LOG4J_CONFIGURATION_FILE_PROPERTY = "log4j.configurationFile";

    public LoggerContext build(ClassLoader classLoader, ContextSelector selector, boolean logSeparationEnabled) {
        NewContextParameters parameters = this.resolveContextParameters(classLoader);
        if (parameters == null) {
            return this.getDefaultContext(selector, logSeparationEnabled);
        }
        MuleLoggerContext loggerContext = new MuleLoggerContext(parameters.contextName, parameters.log4jConfigFile, classLoader, selector, this.isStandalone(), logSeparationEnabled);
        if (classLoader instanceof ArtifactClassLoader && selector instanceof ArtifactAwareContextSelector) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            artifactClassLoader.addShutdownListener(() -> ((ArtifactAwareContextSelector)selector).destroyLoggersFor(ArtifactAwareContextSelector.resolveLoggerContextClassLoader(classLoader)));
        }
        return loggerContext;
    }

    private NewContextParameters resolveContextParameters(ClassLoader classLoader) {
        if (classLoader instanceof ArtifactClassLoader) {
            ArtifactClassLoader artifactClassLoader = (ArtifactClassLoader)((Object)classLoader);
            return new NewContextParameters(this.getArtifactLog4JConfig(artifactClassLoader), artifactClassLoader.getArtifactId());
        }
        if (MuleContainerUtils.getMuleConfDir() != null) {
            return new NewContextParameters(this.findLog4JConfig(new DirectoryResourceLocator(MuleContainerUtils.getMuleConfDir().getAbsolutePath())), classLoader.toString());
        }
        return null;
    }

    private URI getArtifactLog4JConfig(ArtifactClassLoader muleCL) {
        URI appLogConfig;
        try {
            DeployableArtifactDescriptor appDescriptor = (DeployableArtifactDescriptor)muleCL.getArtifactDescriptor();
            if (appDescriptor.getLogConfigFile() == null) {
                appLogConfig = this.findLog4JConfig(muleCL);
            } else if (!appDescriptor.getLogConfigFile().exists()) {
                ArtifactAwareContextSelector.LOGGER.warn("Configured 'log.configFile' in app descriptor points to a non-existant file. Using default configuration.");
                appLogConfig = this.findLog4JConfig(muleCL);
            } else {
                appLogConfig = appDescriptor.getLogConfigFile().toURI();
            }
        }
        catch (Exception e) {
            ArtifactAwareContextSelector.LOGGER.warn("{} while looking for 'log.configFile' entry in app descriptor: {}. Using default configuration.", (Object)e.getClass().getName(), (Object)e.getMessage());
            appLogConfig = this.findLog4JConfig(muleCL);
        }
        if (appLogConfig != null && ArtifactAwareContextSelector.LOGGER.isInfoEnabled()) {
            ArtifactAwareContextSelector.LOGGER.info("Found logging config for application '{}' at '{}'", (Object)muleCL.getArtifactId(), (Object)appLogConfig);
        }
        return appLogConfig;
    }

    private LoggerContext getDefaultContext(ContextSelector selector, boolean logSeparationEnabled) {
        return new MuleLoggerContext("Default", selector, this.isStandalone(), logSeparationEnabled);
    }

    private boolean isStandalone() {
        return MuleContainerUtils.getMuleConfDir() != null;
    }

    private URI findLog4JConfig(LocalResourceLocator localResourceLocator) {
        URI appLogConfig = null;
        appLogConfig = MuleLoggerContextFactory.findTestLog4JConfig(localResourceLocator, appLogConfig);
        URI fallbackLogConfig = new File(MuleContainerUtils.getMuleBase(), "conf/log4j2.xml").toURI();
        if (appLogConfig == null) {
            appLogConfig = MuleLoggerContextFactory.findLog4JConfig(localResourceLocator, fallbackLogConfig, appLogConfig);
        }
        if (appLogConfig == null) {
            appLogConfig = System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY) != null ? new File(System.getProperty(LOG4J_CONFIGURATION_FILE_PROPERTY)).toURI() : fallbackLogConfig;
        }
        return appLogConfig;
    }

    private static URI findLog4JConfig(LocalResourceLocator localResourceLocator, URI fallbackLogConfig, URI appLogConfig) {
        URL localResource = localResourceLocator.findLocalResource("log4j2.xml");
        try {
            if (localResource != null && !fallbackLogConfig.equals(localResource.toURI())) {
                appLogConfig = localResource.toURI();
            }
        }
        catch (URISyntaxException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not read log file " + String.valueOf(appLogConfig)), (Throwable)e);
        }
        return appLogConfig;
    }

    private static URI findTestLog4JConfig(LocalResourceLocator localResourceLocator, URI appLogConfig) {
        URL localResource = localResourceLocator.findLocalResource("log4j2-test.xml");
        if (localResource != null) {
            try {
                appLogConfig = localResource.toURI();
            }
            catch (URISyntaxException e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not read log file " + String.valueOf(appLogConfig)), (Throwable)e);
            }
        }
        return appLogConfig;
    }

    private record NewContextParameters(URI log4jConfigFile, String contextName) {
    }
}

