/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.forkjoin;

import jakarta.inject.Inject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.routing.forkjoin.AbstractForkJoinStrategyFactory;

public class CollectListForkJoinStrategyFactory
extends AbstractForkJoinStrategyFactory
implements Component {
    private volatile Map<QName, Object> annotations = Collections.emptyMap();
    private ComponentLocation location;
    private Location rootContainerLocation;

    @Inject
    public CollectListForkJoinStrategyFactory(FeatureFlaggingService featureFlaggingService) {
        super(featureFlaggingService);
    }

    public CollectListForkJoinStrategyFactory(boolean mergeVariables, FeatureFlaggingService featureFlaggingService) {
        super(mergeVariables, featureFlaggingService);
    }

    @Override
    protected Function<List<CoreEvent>, CoreEvent> createResultEvent(CoreEvent original, CoreEvent.Builder resultBuilder) {
        return list -> resultBuilder.message(Message.of(list.stream().map(event -> event.getMessage()).collect(Collectors.toList()))).build();
    }

    @Override
    public DataType getResultDataType() {
        return DataType.MULE_MESSAGE_LIST;
    }

    @Override
    public Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    @Override
    public Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    @Override
    public void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations = new HashMap<QName, Object>(newAnnotations);
        this.location = (ComponentLocation)this.getAnnotation(AbstractComponent.LOCATION_KEY);
        this.rootContainerLocation = this.initRootContainerName();
    }

    protected Location initRootContainerName() {
        String rootContainerName = (String)this.getAnnotation(AbstractComponent.ROOT_CONTAINER_NAME_KEY);
        if (rootContainerName == null && this.getLocation() != null) {
            rootContainerName = this.getLocation().getRootContainerName();
        }
        return rootContainerName == null ? null : Location.builder().globalName(rootContainerName).build();
    }

    @Override
    public ComponentLocation getLocation() {
        return this.location;
    }

    @Override
    public Location getRootContainerLocation() {
        return this.rootContainerLocation;
    }
}

