/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.api.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.mule.api.annotation.Experimental;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.metadata.ComponentMetadataConfigurer;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.metadata.internal.DefaultMetadataResolverFactory;
import org.mule.runtime.metadata.internal.NullMetadataResolverFactory;
import org.mule.runtime.metadata.internal.NullMetadataResolverSupplier;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ModelLoaderUtils;
import org.mule.runtime.module.extension.internal.metadata.chain.AllOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.OneOfRoutesOutputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.PassThroughChainInputTypeResolver;
import org.mule.runtime.module.extension.internal.metadata.chain.PassThroughChainOutputTypeResolver;
import org.mule.sdk.api.annotation.MinMuleVersion;
import org.mule.sdk.api.metadata.resolving.ChainInputTypeResolver;

@MinMuleVersion(value="4.7.0")
@Experimental
public final class DefaultComponentMetadataConfigurer
implements ComponentMetadataConfigurer {
    private TypeKeysResolver keysResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private String keyParameterName;
    private MetadataType keyParameterType;
    private boolean hasPartialKeyResolver = false;
    private OutputTypeResolver outputTypeResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private AttributesTypeResolver attributesTypeResolver = NullMetadataResolverSupplier.NULL_METADATA_RESOLVER;
    private final Map<String, Supplier<? extends InputTypeResolver>> inputResolvers = new HashMap<String, Supplier<? extends InputTypeResolver>>();
    private final Map<String, String> inputResolverNames = new HashMap<String, String>();
    private String firstSeenInputResolverCategory = null;
    private ChainInputTypeResolver chainInputTypeResolver;
    private final Map<String, ChainInputTypeResolver> routesChainInputTypesResolvers = new HashMap<String, ChainInputTypeResolver>();
    private boolean connected = false;

    @Override
    public <T extends ParameterizedDeclaration> void configureNullMetadata(ParameterizedDeclaration<T> declaration) {
        declaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> new NullMetadataResolverFactory()));
    }

    @Override
    public <T extends ParameterizedDeclarer, D extends ParameterizedDeclaration> void configureNullMetadata(ParameterizedDeclarer<T, D> declarer) {
        this.configureNullMetadata((ParameterizedDeclaration)declarer.getDeclaration());
    }

    @Override
    public DefaultComponentMetadataConfigurer setOutputTypeResolver(OutputTypeResolver outputTypeResolver) {
        Objects.requireNonNull(outputTypeResolver, "outputTypeResolver cannot be null");
        this.outputTypeResolver = outputTypeResolver;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer setAttributesTypeResolver(AttributesTypeResolver attributesTypeResolver) {
        Objects.requireNonNull(attributesTypeResolver, "attributesTypeResolver cannot be null");
        this.attributesTypeResolver = attributesTypeResolver;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer setKeysResolver(TypeKeysResolver keysResolver, String keyParameterName, MetadataType keyParameterType, boolean isPartialKeyResolver) {
        Objects.requireNonNull(keysResolver, "keysResolver cannot be null");
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)keyParameterName), "keyParameterName cannot be blank");
        Objects.requireNonNull(keyParameterType, "keyParameterType cannot be null");
        this.keysResolver = keysResolver;
        this.keyParameterName = keyParameterName;
        this.keyParameterType = keyParameterType;
        this.hasPartialKeyResolver = isPartialKeyResolver;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer setChainInputTypeResolver(ChainInputTypeResolver chainInputTypeResolver) {
        this.chainInputTypeResolver = chainInputTypeResolver;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer withPassThroughChainInputTypeResolver() {
        this.chainInputTypeResolver = PassThroughChainInputTypeResolver.INSTANCE;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer addInputResolver(String parameterName, InputTypeResolver resolver) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)parameterName), "parameterName cannot be blank");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        this.inputResolvers.put(parameterName, () -> resolver);
        this.inputResolverNames.put(parameterName, resolver.getResolverName());
        if (this.firstSeenInputResolverCategory == null) {
            this.firstSeenInputResolverCategory = resolver.getCategoryName();
        }
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer addInputResolvers(Map<String, InputTypeResolver> resolvers) {
        Objects.requireNonNull(resolvers, "resolvers cannot be null");
        resolvers.forEach(this::addInputResolver);
        return this;
    }

    @Override
    public ComponentMetadataConfigurer addRoutePassThroughChainInputResolver(String routeName) {
        return this.addRouteChainInputResolver(routeName, PassThroughChainInputTypeResolver.INSTANCE);
    }

    @Override
    public DefaultComponentMetadataConfigurer addRouteChainInputResolver(String routeName, ChainInputTypeResolver resolver) {
        Preconditions.checkArgument(!StringUtils.isBlank((CharSequence)routeName), "routeName cannot be blank");
        Objects.requireNonNull(resolver, "resolver cannot be null");
        this.routesChainInputTypesResolvers.put(routeName, resolver);
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer addRoutesChainInputResolvers(Map<String, ChainInputTypeResolver> resolvers) {
        Objects.requireNonNull(resolvers, "resolvers cannot be null");
        resolvers.forEach(this::addRouteChainInputResolver);
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer setConnected(boolean connected) {
        this.connected = connected;
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer asOneOfRouter() {
        this.setOutputTypeResolver(OneOfRoutesOutputTypeResolver.INSTANCE);
        this.setAttributesTypeResolver(OneOfRoutesOutputTypeResolver.INSTANCE);
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer asPassthroughScope() {
        if (this.chainInputTypeResolver == null) {
            this.withPassThroughChainInputTypeResolver();
        }
        this.setOutputTypeResolver(PassThroughChainOutputTypeResolver.INSTANCE);
        this.setAttributesTypeResolver(PassThroughChainOutputTypeResolver.INSTANCE);
        return this;
    }

    @Override
    public DefaultComponentMetadataConfigurer asAllOfRouter() {
        this.setOutputTypeResolver(AllOfRoutesOutputTypeResolver.INSTANCE);
        return this;
    }

    @Override
    public <T extends ParameterizedDeclarer, D extends ParameterizedDeclaration> void configure(ParameterizedDeclarer<T, D> declarer) {
        this.configure((ParameterizedDeclaration)declarer.getDeclaration());
    }

    @Override
    public <T extends ComponentDeclaration> void configure(ParameterizedDeclaration<T> declaration) {
        declaration.addModelProperty(this.buildFactoryModelProperty());
        this.buildResolverInformationModelProperty(declaration).ifPresent(declaration::addModelProperty);
        if (this.keysResolver != NullMetadataResolverSupplier.NULL_METADATA_RESOLVER) {
            declaration.addModelProperty(new MetadataKeyIdModelProperty(this.keyParameterType, this.keyParameterName, ModelLoaderUtils.getCategoryName(this.keysResolver, this.firstSeenInputResolverCategory, this.outputTypeResolver)));
        }
    }

    private MetadataResolverFactoryModelProperty buildFactoryModelProperty() {
        return new MetadataResolverFactoryModelProperty(() -> new DefaultMetadataResolverFactory(() -> this.keysResolver, this.copy(this.inputResolvers), () -> this.outputTypeResolver, () -> this.attributesTypeResolver, Optional.ofNullable(this.chainInputTypeResolver), this.copy(this.routesChainInputTypesResolvers)));
    }

    private Optional<TypeResolversInformationModelProperty> buildResolverInformationModelProperty(ParameterizedDeclaration declaration) {
        String categoryName = ModelLoaderUtils.getCategoryName(this.keysResolver, this.firstSeenInputResolverCategory, this.outputTypeResolver);
        if (StringUtils.isBlank((CharSequence)categoryName)) {
            return Optional.empty();
        }
        return Optional.of(new TypeResolversInformationModelProperty(categoryName, this.copy(this.inputResolverNames), this.outputTypeResolver.getResolverName(), this.attributesTypeResolver.getResolverName(), this.keysResolver.getResolverName(), this.connected, this.connected, this.hasPartialKeyResolver));
    }

    private <K, V> Map<K, V> copy(Map<K, V> map) {
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }
}

