/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.simple;

import jakarta.inject.Inject;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.util.WildcardAttributeEvaluator;
import org.mule.runtime.core.internal.util.attribute.AttributeEvaluator;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.core.privileged.processor.simple.SimpleMessageProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFlowVariableProcessor
extends SimpleMessageProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoveFlowVariableProcessor.class);
    private ExtendedExpressionManager expressionManager;
    private AttributeEvaluator identifierEvaluator;
    private WildcardAttributeEvaluator wildcardAttributeEvaluator;

    @Override
    public void initialise() throws InitialisationException {
        this.identifierEvaluator.initialize(this.expressionManager);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        if (this.wildcardAttributeEvaluator.hasWildcards()) {
            AtomicReference<CoreEvent> resultEvent = new AtomicReference<CoreEvent>(event);
            this.wildcardAttributeEvaluator.processValues(this.getPropertyNames((PrivilegedEvent)event), matchedValue -> {
                LOGGER.debug("Removing property: '{}'", (Object)matchedValue);
                resultEvent.set(this.removeProperty((PrivilegedEvent)event, matchedValue));
            });
            return resultEvent.get();
        }
        String key = (String)this.identifierEvaluator.resolveValue(event);
        if (key != null) {
            return this.removeProperty((PrivilegedEvent)event, key);
        }
        LOGGER.info("Key expression return null, no property will be removed");
        return event;
    }

    protected Set<String> getPropertyNames(PrivilegedEvent event) {
        return event.getVariables().keySet();
    }

    protected PrivilegedEvent removeProperty(PrivilegedEvent event, String propertyName) {
        if (event.getVariables().containsKey(propertyName)) {
            return PrivilegedEvent.builder(event).removeVariable(propertyName).build();
        }
        LOGGER.warn("There is no variable named '{}'. Check the 'variableName' parameter in the 'remove-variable' component at {}", (Object)propertyName, (Object)this.getLocation().getLocation());
        return event;
    }

    public void setIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            throw new IllegalArgumentException("Remove with null identifier is not supported");
        }
        this.identifierEvaluator = new AttributeEvaluator(identifier, DataType.STRING);
        this.wildcardAttributeEvaluator = new WildcardAttributeEvaluator(identifier);
    }

    @Inject
    public void setExpressionManager(ExtendedExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
    }
}

