/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.serialization;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.commons.lang3.SerializationException;

public class SerializationUtils {
    public static Object deserialize(InputStream inputStream, ClassLoader cl) {
        if (inputStream == null) {
            throw new IllegalArgumentException("The InputStream must not be null");
        }
        if (cl == null) {
            throw new IllegalArgumentException("The ClassLoader must not be null");
        }
        ClassLoaderObjectInputStream in = null;
        try {
            in = new ClassLoaderObjectInputStream(cl, inputStream);
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (IOException ex) {
            throw new SerializationException((Throwable)ex);
        }
        catch (Exception ex) {
            throw new SerializationException((Throwable)ex);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static Object deserialize(byte[] objectData, ClassLoader cl) {
        if (objectData == null) {
            throw new IllegalArgumentException("The byte[] must not be null");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(objectData);
        return SerializationUtils.deserialize(bais, cl);
    }
}

