/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.support.internal.server;

import java.io.IOException;
import java.util.Collection;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.sse.server.SseRequestContext;
import org.mule.runtime.http.support.internal.server.EndpointLifecycleHandlerWrapper;
import org.mule.runtime.http.support.internal.server.RequestHandlerWrapper;
import org.mule.runtime.http.support.internal.server.ServerAddressWrapper;
import org.mule.runtime.http.support.internal.server.SseClientWrapper;
import org.mule.runtime.http.support.internal.server.SseEndpointManagerWrapper;
import org.mule.runtime.http.support.internal.server.SseRequestContextWrapper;
import org.mule.sdk.api.http.HttpConstants;
import org.mule.sdk.api.http.server.EndpointLifecycleHandler;
import org.mule.sdk.api.http.server.RequestHandler;
import org.mule.sdk.api.http.server.ServerAddress;
import org.mule.sdk.api.http.sse.server.SseClient;
import org.mule.sdk.api.http.sse.server.SseEndpointManager;

public class HttpServerWrapper
implements org.mule.sdk.api.http.server.HttpServer {
    private final HttpServer delegate;
    private final ServerAddress serverAddress;

    public HttpServerWrapper(HttpServer delegate) {
        this.delegate = delegate;
        this.serverAddress = new ServerAddressWrapper(delegate.getServerAddress());
    }

    @Override
    public void start() throws MuleException {
        try {
            this.delegate.start();
        }
        catch (IOException e) {
            throw new LifecycleException(e, (Object)this);
        }
    }

    @Override
    public void stop() {
        this.delegate.stop();
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public HttpConstants.Protocol getProtocol() {
        return HttpConstants.Protocol.valueOf(this.delegate.getProtocol().name());
    }

    @Override
    public boolean isStopping() {
        return this.delegate.isStopping();
    }

    @Override
    public boolean isStopped() {
        return this.delegate.isStopped();
    }

    @Override
    public void enableTls(TlsContextFactory tlsContextFactory) {
        this.delegate.enableTls(tlsContextFactory);
    }

    @Override
    public void disableTls() {
        this.delegate.disableTls();
    }

    @Override
    public EndpointLifecycleHandler addRequestHandler(Collection<String> methods, String path, RequestHandler requestHandler) {
        return new EndpointLifecycleHandlerWrapper(this.delegate.addRequestHandler(methods, path, new RequestHandlerWrapper(requestHandler)));
    }

    @Override
    public EndpointLifecycleHandler addRequestHandler(String path, RequestHandler requestHandler) {
        return new EndpointLifecycleHandlerWrapper(this.delegate.addRequestHandler(path, new RequestHandlerWrapper(requestHandler)));
    }

    @Override
    public SseEndpointManager sse(String ssePath, Consumer<org.mule.sdk.api.http.sse.server.SseRequestContext> onRequest, Consumer<SseClient> onClient) {
        return new SseEndpointManagerWrapper(this.delegate.sse(ssePath, (SseRequestContext ctx) -> onRequest.accept(new SseRequestContextWrapper((SseRequestContext)ctx)), (org.mule.runtime.http.api.sse.server.SseClient sseClient) -> onClient.accept(new SseClientWrapper((org.mule.runtime.http.api.sse.server.SseClient)sseClient))));
    }
}

