/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import jakarta.inject.Inject;
import java.util.List;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMuleObjectOwner<T>
extends AbstractComponent
implements Lifecycle,
MuleContextAware {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Inject
    protected MuleContext muleContext;
    @Inject
    protected ConfigurationComponentLocator locator;

    @Override
    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
        LifecycleUtils.setMuleContextIfNeeded(this.getOwnedObjects(), muleContext);
    }

    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public void initialise() throws InitialisationException {
        this.setMuleContext(this.muleContext);
        LifecycleUtils.initialiseIfNeeded(this.getOwnedObjects(), true, this.muleContext);
    }

    @Override
    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.getOwnedObjects(), this.logger);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.getOwnedObjects());
    }

    @Override
    public void stop() throws MuleException {
        LifecycleUtils.stopIfNeeded(this.getOwnedObjects());
    }

    protected abstract List<T> getOwnedObjects();
}

