/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelLoaderRepository;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginClassLoaderSupplier;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactPluginDescriptor;
import org.mule.runtime.module.deployment.impl.internal.artifact.CompositeArtifactExtensionManagerFactory;
import org.mule.runtime.module.deployment.impl.internal.policy.ArtifactExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.DefaultExtensionManagerFactory;
import org.mule.runtime.module.extension.api.manager.ExtensionManagerFactory;

class PolicyExtensionManagerFactory
implements ExtensionManagerFactory {
    static final String SOCKETS_EXTENSION_NAME = "Sockets";
    static final String HTTP_EXTENSION_NAME = "HTTP";
    private final Application application;
    private final PolicyTemplate template;
    private final ExtensionModelLoaderRepository extensionModelLoaderRepository;
    private final boolean enablePolicyIsolation;
    private final Optional<BiFunction<PluginClassLoaderSupplier, ExtensionModelLoaderRepository, ExtensionModelDiscoverer>> extModelDiscovererOverride;

    public PolicyExtensionManagerFactory(Application application, PolicyTemplate template, ExtensionModelLoaderRepository extensionModelLoaderRepository, boolean enablePolicyIsolation) {
        this(application, template, extensionModelLoaderRepository, enablePolicyIsolation, null);
    }

    public PolicyExtensionManagerFactory(Application application, PolicyTemplate template, ExtensionModelLoaderRepository extensionModelLoaderRepository, boolean enablePolicyIsolation, BiFunction<PluginClassLoaderSupplier, ExtensionModelLoaderRepository, ExtensionModelDiscoverer> extModelDiscoverer) {
        this.application = application;
        this.template = template;
        this.extensionModelLoaderRepository = extensionModelLoaderRepository;
        this.enablePolicyIsolation = enablePolicyIsolation;
        this.extModelDiscovererOverride = Optional.ofNullable(extModelDiscoverer);
    }

    @Override
    public ExtensionManager create(MuleContext muleContext) {
        try {
            if (this.enablePolicyIsolation) {
                ArtifactExtensionManagerFactory artifactExtensionManagerFactory = new ArtifactExtensionManagerFactory(this.template.getOwnArtifactPlugins(), this.extensionModelLoaderRepository, new DefaultExtensionManagerFactory(), this.extModelDiscovererOverride);
                return artifactExtensionManagerFactory.create(muleContext, this.getInheritedExtensionModels());
            }
            CompositeArtifactExtensionManagerFactory artifactExtensionManagerFactory = new CompositeArtifactExtensionManagerFactory(this.application, this.extensionModelLoaderRepository, this.nonInheritedOwnArtifactPlugins(), new DefaultExtensionManagerFactory(), this.extModelDiscovererOverride);
            return artifactExtensionManagerFactory.create(muleContext);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    private List<ArtifactPlugin> nonInheritedOwnArtifactPlugins() {
        Set inheritedExtensionModelNames = this.getInheritedExtensionModels().stream().map(ExtensionModel::getName).collect(Collectors.toSet());
        return this.template.getOwnArtifactPlugins().stream().filter(ownAP -> !inheritedExtensionModelNames.contains(((ArtifactPluginDescriptor)ownAP.getDescriptor()).getName())).collect(Collectors.toList());
    }

    private Set<ExtensionModel> getInheritedExtensionModels() {
        HashSet<ExtensionModel> inheritedExtensionModels = new HashSet<ExtensionModel>(2);
        ExtensionManager extensionManager = (ExtensionManager)this.application.getRegistry().lookupByName("_muleExtensionManager").get();
        extensionManager.getExtension(HTTP_EXTENSION_NAME).ifPresent(inheritedExtensionModels::add);
        extensionManager.getExtension(SOCKETS_EXTENSION_NAME).ifPresent(inheritedExtensionModels::add);
        return inheritedExtensionModels;
    }
}

