/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Optional;
import java.util.concurrent.RejectedExecutionException;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleFatalException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.security.ClientSecurityException;
import org.mule.runtime.api.security.NotPermittedException;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.ServerSecurityException;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.runtime.ast.api.error.ErrorTypeBuilder;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.exception.ExceptionMapper;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.transformer.MessageTransformerException;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.internal.construct.FlowBackPressureException;
import org.mule.runtime.core.internal.event.EventContextDeepNestingException;
import org.mule.runtime.core.internal.exception.ValidationException;
import org.mule.runtime.core.internal.routing.result.RoutingException;
import org.mule.runtime.core.internal.routing.split.DuplicateMessageException;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessageRedeliveredException;
import org.mule.runtime.core.privileged.routing.CompositeRoutingException;

public final class ErrorTypeLocatorFactory {
    private ErrorTypeLocatorFactory() {
    }

    public static ErrorTypeLocator createDefaultErrorTypeLocator(ErrorTypeRepository errorTypeRepository) {
        return ErrorTypeLocatorFactory.createDefaultErrorTypeLocator(errorTypeRepository, Optional.empty());
    }

    public static ErrorTypeLocator createDefaultErrorTypeLocator(ErrorTypeRepository errorTypeRepository, Optional<FeatureFlaggingService> featureFlaggingService) {
        ErrorType unknown = errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.UNKNOWN).orElseThrow();
        return ErrorTypeLocator.builder(errorTypeRepository).defaultExceptionMapper(ExceptionMapper.builder().addExceptionMapping(MessageTransformerException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.TRANSFORMATION).orElseThrow()).addExceptionMapping(TransformerException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.TRANSFORMATION).orElseThrow()).addExceptionMapping(ExpressionRuntimeException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.EXPRESSION).orElseThrow()).addExceptionMapping(RoutingException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING).orElseThrow()).addExceptionMapping(CompositeRoutingException.class, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING).orElseThrow()).addExceptionMapping(ConnectionException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY).orElseThrow()).addExceptionMapping(ValidationException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.VALIDATION).orElseThrow()).addExceptionMapping(DuplicateMessageException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE).orElseThrow()).addExceptionMapping(RetryPolicyExhaustedException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED).orElseThrow()).addExceptionMapping(SecurityException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).orElseThrow()).addExceptionMapping(ClientSecurityException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY).orElseThrow()).addExceptionMapping(ServerSecurityException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).orElseThrow()).addExceptionMapping(NotPermittedException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED).orElseThrow()).addExceptionMapping(RejectedExecutionException.class, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).orElseThrow()).addExceptionMapping(FlowBackPressureException.class, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE).orElseThrow()).addExceptionMapping(MessageRedeliveredException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED).orElseThrow()).addExceptionMapping(Exception.class, unknown).addExceptionMapping(EventContextDeepNestingException.class, errorTypeRepository.getCriticalErrorType()).addExceptionMapping(Error.class, errorTypeRepository.getCriticalErrorType()).addExceptionMapping(StreamingBufferSizeExceededException.class, errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED).orElseThrow()).addExceptionMapping(MuleFatalException.class, errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.FATAL).orElseThrow()).addExceptionMapping(TransactionException.class, ErrorTypeLocatorFactory.useTransactionErrorIfEnabled(errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Handleable.TRANSACTION).orElseGet(ErrorTypeLocatorFactory::createTransactionError), unknown, featureFlaggingService)).addExceptionMapping(InterruptedException.class, ErrorTypeLocatorFactory.raiseCancelledErrorOnForcefulShutdown(errorTypeRepository.lookupErrorType(Errors.ComponentIdentifiers.Unhandleable.CANCELLED).orElse(unknown), unknown, featureFlaggingService)).build()).defaultError(unknown).build();
    }

    private static ErrorType createTransactionError() {
        ErrorType anyError = ErrorTypeBuilder.builder().namespace(Errors.ComponentIdentifiers.Handleable.ANY.getNamespace()).identifier(Errors.ComponentIdentifiers.Handleable.ANY.getName()).build();
        return ErrorTypeBuilder.builder().namespace(Errors.ComponentIdentifiers.Handleable.TRANSACTION.getNamespace()).identifier(Errors.ComponentIdentifiers.Handleable.TRANSACTION.getName()).parentErrorType(anyError).build();
    }

    private static ErrorType useTransactionErrorIfEnabled(ErrorType txError, ErrorType unknown, Optional<FeatureFlaggingService> featureFlaggingService) {
        return featureFlaggingService.map(service -> service.isEnabled(MuleRuntimeFeature.ERROR_AND_ROLLBACK_TX_WHEN_TIMEOUT) ? txError : unknown).orElse(txError);
    }

    private static ErrorType raiseCancelledErrorOnForcefulShutdown(ErrorType cancelledError, ErrorType unknown, Optional<FeatureFlaggingService> featureFlaggingService) {
        return featureFlaggingService.map(service -> service.isEnabled(MuleRuntimeFeature.RAISE_CANCELLED_ERROR_ON_FORCEFUL_SHUTDOWN) ? cancelledError : unknown).orElse(cancelledError);
    }
}

