/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.SimpleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentParameterAstBuilder;
import org.mule.runtime.ast.api.model.ExtensionModelHelper;
import org.mule.runtime.ast.internal.DefaultComponentAst;
import org.mule.runtime.ast.internal.builder.ApplicationModelTypeUtils;
import org.mule.runtime.ast.internal.builder.BaseComponentAstBuilder;
import org.mule.runtime.ast.internal.builder.ComponentLocationVisitor;
import org.mule.runtime.ast.internal.builder.DefaultComponentParameterAstBuilder;
import org.mule.runtime.ast.internal.builder.ParameterKey;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeModelAdapter;
import org.mule.runtime.ast.internal.model.ParameterModelUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;

public class DefaultComponentAstBuilder
extends BaseComponentAstBuilder<DefaultComponentAstBuilder> {
    private final ExtensionModelHelper extModelHelper;
    private final List<DefaultComponentAstBuilder> hierarchy;
    private final int indexInParent;
    private final ComponentLocationVisitor componentLocationVisitor;

    public DefaultComponentAstBuilder(PropertiesResolver propertiesResolver, ExtensionModelHelper extModelHelper, List<DefaultComponentAstBuilder> hierarchy, int indexInParent, ComponentLocationVisitor componentLocationVisitor, ParameterModelUtils parameterModelUtils) {
        super(propertiesResolver, parameterModelUtils);
        this.extModelHelper = extModelHelper;
        this.hierarchy = hierarchy;
        this.indexInParent = indexInParent;
        this.componentLocationVisitor = componentLocationVisitor;
    }

    @Override
    public ComponentAstBuilder addChildComponent() {
        ArrayList<DefaultComponentAstBuilder> childHierarchy = new ArrayList<DefaultComponentAstBuilder>(this.hierarchy);
        childHierarchy.add(this);
        DefaultComponentAstBuilder componentAstBuilder = new DefaultComponentAstBuilder(this.getPropertiesResolver(), this.extModelHelper, childHierarchy, (int)this.childComponentsStream().count(), this.componentLocationVisitor, this.getParameterModelUtils());
        this.addChildComponent(componentAstBuilder);
        return componentAstBuilder;
    }

    @Override
    public ComponentParameterAst addParameter(ParameterModel paramModel, ParameterGroupModel parameterGroupModel, Consumer<ComponentParameterAstBuilder> paramConfigurer) {
        DefaultComponentParameterAstBuilder paramBuilder = new DefaultComponentParameterAstBuilder();
        paramBuilder.withParamModel(paramModel, parameterGroupModel);
        paramBuilder.withOwnerComponent(this);
        paramConfigurer.accept(paramBuilder);
        DefaultComponentAstBuilder value = paramBuilder.getComplexValue();
        ArrayList<ComponentIdentifier> childParamIds = new ArrayList<ComponentIdentifier>();
        if (value instanceof ComponentAstBuilder) {
            ComponentAstBuilder paramComponent = value;
            childParamIds.add(paramComponent.getIdentifier());
        }
        DslElementSyntax paramDsl = this.extModelHelper.resolveDslElementModel(paramModel, this.getIdentifier());
        DefaultComponentAstBuilder.getIdentifier(paramDsl).map(id -> ComponentIdentifier.builder().namespace(this.getIdentifier().getNamespace()).namespaceUri(this.getIdentifier().getNamespaceUri()).name(id.getName()).build()).ifPresent(childParamIds::add);
        ComponentParameterAst paramValue = paramBuilder.build();
        this.withParameter(paramModel, parameterGroupModel, paramValue, childParamIds);
        return paramValue;
    }

    private static Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        return DefaultComponentAstBuilder.getIdentifier(dsl.getElementName(), dsl.getPrefix());
    }

    private static Optional<ComponentIdentifier> getIdentifier(String elementName, String prefix) {
        if (StringUtils.isNotBlank((CharSequence)elementName) && StringUtils.isNotBlank((CharSequence)prefix)) {
            return Optional.of(ComponentIdentifier.builder().name(elementName).namespace(prefix).build());
        }
        return Optional.empty();
    }

    @Override
    public ComponentAstBuilder withIdentifier(ComponentIdentifier identifier) {
        this.extModelHelper.lookupExtensionModelFor(identifier).ifPresent(this::withExtensionModel);
        return super.withIdentifier(identifier);
    }

    @Override
    public ComponentAstBuilder withTypedModel(final MetadataType type) {
        type.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                MetadataTypeModelAdapter model = MetadataTypeModelAdapter.createMetadataTypeModelAdapterWithStereotype(type, DefaultComponentAstBuilder.this.extModelHelper).orElseGet(() -> MetadataTypeModelAdapter.createParameterizedTypeModelAdapter(type, DefaultComponentAstBuilder.this.extModelHelper));
                DefaultComponentAstBuilder.this.withParameterizedModel(model);
                this.withSyntaxFor(metadataType, model);
            }

            @Override
            public void visitSimpleType(SimpleType simpleType) {
                MetadataTypeModelAdapter model = MetadataTypeModelAdapter.createSimpleWrapperTypeModelAdapter(simpleType, DefaultComponentAstBuilder.this.extModelHelper);
                DefaultComponentAstBuilder.this.withParameterizedModel(model);
            }

            private void withSyntaxFor(MetadataType type2, MetadataTypeModelAdapter model) {
                DefaultComponentAstBuilder.this.getGenerationInformation().withSyntax(DefaultComponentAstBuilder.this.extModelHelper.resolveDslElementModel(type2, DefaultComponentAstBuilder.this.getExtensionModel()).orElseGet(() -> DefaultComponentAstBuilder.this.extModelHelper.resolveDslElementModel(model, DefaultComponentAstBuilder.this.getIdentifier())));
            }
        });
        return this;
    }

    @Override
    public ComponentAst get() {
        return this.build();
    }

    @Override
    public ComponentAst build() {
        this.prepareForBuild();
        return this.doBuild();
    }

    @Override
    public void prepareForBuild() {
        Objects.requireNonNull(this.getIdentifier(), () -> "identifier @ " + this.hierarchyString());
        Objects.requireNonNull(this.getMetadata(), () -> "metadata @ " + this.hierarchyString());
        if (!this.getModel(Object.class).isPresent()) {
            ApplicationModelTypeUtils.resolveTypedComponentIdentifier(this, this.getParent(), this.extModelHelper);
        }
        super.prepareForBuild();
        this.childComponentsStream().forEach(DefaultComponentAstBuilder::prepareForBuild);
    }

    private String hierarchyString() {
        return this.hierarchy.stream().map(hierarchyItem -> "" + hierarchyItem.getIndexInParent() + "(" + this.identifierString((DefaultComponentAstBuilder)hierarchyItem) + ")").collect(Collectors.joining("/", "/", "/")) + this.getIndexInParent() + this.identifierString(this);
    }

    private String identifierString(DefaultComponentAstBuilder builder) {
        return builder.getIdentifier() != null ? builder.getIdentifier().toString() : "";
    }

    private Optional<ComponentAstBuilder> getParent() {
        if (this.hierarchy.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((ComponentAstBuilder)this.hierarchy.get(this.hierarchy.size() - 1));
    }

    private ComponentAst doBuild() {
        Map<ParameterKey, ComponentParameterAst> parameterAsts = this.createParameterAsts();
        List<ComponentAst> builtChildren = this.childComponentsStream().map(DefaultComponentAstBuilder::doBuild).collect(Collectors.toList());
        Set paramNames = parameterAsts.keySet().stream().map(ParameterKey::getParamName).collect(Collectors.toSet());
        Map<String, String> extraParams = this.getRawParameters().entrySet().stream().filter(e -> paramNames.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Supplier<Optional<String>> componentId = this.obtainLocation(parameterAsts);
        return new DefaultComponentAst(builtChildren, parameterAsts, extraParams, this.getPropertiesResolver(), this.getAnnotations(), componentId, this.getExtensionModel(), this.getModel(ComponentModel.class).orElse(null), this.getModel(NestableElementModel.class).orElse(null), this.getModel(ConfigurationModel.class).orElse(null), this.getModel(ConnectionProviderModel.class).orElse(null), this.getModel(ParameterizedModel.class).orElse(null), this.getType(), this.getGenerationInformation().build(), this.getMetadata(), this.getLocation(), this.getIdentifier(), this.getComponentType());
    }

    @Override
    public ComponentLocation getLocation() {
        ComponentLocation location = super.getLocation();
        if (location != null) {
            return location;
        }
        this.obtainLocation(this.createParameterAsts());
        return super.getLocation();
    }

    protected Supplier<Optional<String>> obtainLocation(Map<ParameterKey, ComponentParameterAst> parameterAsts) {
        LazyValue<Supplier<Optional>> componentId = new LazyValue<Supplier<Optional>>(() -> this.resolveComponentId(parameterAsts));
        this.setComponentId(componentId);
        this.componentLocationVisitor.resolveLocation(this, this.hierarchy);
        return componentId;
    }

    public int getIndexInParent() {
        return this.indexInParent;
    }
}

