/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.util;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.dsl.internal.util.CollectionUtils;
import org.mule.runtime.dsl.internal.util.ResourceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SchemaMappingsUtils {
    public static final String CUSTOM_SCHEMA_MAPPINGS_LOCATION = "META-INF/mule.schemas";
    public static final String CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION = "META-INF/spring.schemas";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchemaMappingsUtils.class);
    private static final LoadingCache<ClassLoader, SchemaMappingsUtils> SCHEMA_MAPINGS_CACHE = Caffeine.newBuilder().weakKeys().build(SchemaMappingsUtils::new);
    private final LazyValue<Map<String, String>> muleSchemasMappings = new LazyValue<Supplier<Map>>(() -> this.getSchemaMappings(CUSTOM_SCHEMA_MAPPINGS_LOCATION, () -> muleImplementationsLoader));
    private final LazyValue<Map<String, String>> springSchemasMappings = new LazyValue<Supplier<Map>>(() -> this.getSchemaMappings(CUSTOM_SPRING_SCHEMA_MAPPINGS_LOCATION, () -> muleImplementationsLoader));

    public static SchemaMappingsUtils getFor(ClassLoader muleImplementationsLoader) {
        return (SchemaMappingsUtils)SCHEMA_MAPINGS_CACHE.get((Object)muleImplementationsLoader);
    }

    private SchemaMappingsUtils(ClassLoader muleImplementationsLoader) {
    }

    public static String resolveSystemId(String systemId) {
        if (systemId.equals("http://www.mulesoft.org/schema/mule/core/current/mule.xsd")) {
            return "http://www.mulesoft.org/schema/mule/core/current/mule-core.xsd";
        }
        if (systemId.contains("spring")) {
            return systemId.replace("-current.xsd", ".xsd");
        }
        return systemId;
    }

    public Map<String, String> getMuleSchemasMappings() {
        return this.muleSchemasMappings.get();
    }

    public Map<String, String> getSpringSchemasMappings() {
        return this.springSchemasMappings.get();
    }

    public Map<String, String> getSchemaMappings(String schemaMappingsLocation, Supplier<ClassLoader> classLoader) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Loading schema mappings from [" + schemaMappingsLocation + "]");
        }
        try {
            Properties appPluginsMappings = this.loadAllProperties(schemaMappingsLocation, classLoader);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Loaded schema mappings: " + appPluginsMappings);
            }
            HashMap<String, String> schemaMappings = new HashMap<String, String>(appPluginsMappings.size());
            CollectionUtils.mergePropertiesIntoMap(appPluginsMappings, schemaMappings);
            return schemaMappings;
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to load schema mappings from location [" + schemaMappingsLocation + "]", ex);
        }
    }

    private Properties loadAllProperties(String resourceName, Supplier<ClassLoader> classLoader) throws IOException {
        ClassLoader classLoaderToUse = classLoader.get();
        Enumeration<URL> urls = classLoaderToUse != null ? classLoaderToUse.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
        Properties props = new Properties();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection con = url.openConnection();
            ResourceUtils.useCachesIfNecessary(con);
            InputStream is = con.getInputStream();
            try {
                if (resourceName != null && resourceName.endsWith(".xml")) {
                    props.loadFromXML(is);
                    continue;
                }
                props.load(is);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
        return props;
    }
}

