/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.apache.xerces.xni.parser.XMLEntityResolver;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.classloader.MuleImplementationLoaderUtils;
import org.mule.runtime.dsl.api.xerces.xni.factories.XmlEntityResolverFactory;
import org.mule.runtime.dsl.api.xerces.xni.factories.XmlGathererErrorHandlerFactory;
import org.mule.runtime.dsl.api.xerces.xni.factories.XmlSchemaProviderFactory;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGathererErrorHandler;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlGrammarPoolBuilder;
import org.mule.runtime.dsl.internal.xerces.xni.parser.XmlSchemaProvider;

public class DefaultXmlGrammarPoolManager {
    private static final LazyValue<Optional<XMLGrammarPool>> INSTANCE = new LazyValue<Supplier<Optional>>(DefaultXmlGrammarPoolManager::initialize);
    private static final Map<ClassLoader, Optional<XMLGrammarPool>> instances = new HashMap<ClassLoader, Optional<XMLGrammarPool>>();

    private DefaultXmlGrammarPoolManager() {
    }

    public static Optional<XMLGrammarPool> getGrammarPool() {
        if (MuleImplementationLoaderUtils.isResolveMuleImplementationLoadersDynamically()) {
            return instances.computeIfAbsent(MuleImplementationLoaderUtils.getMuleImplementationsLoader(), key -> DefaultXmlGrammarPoolManager.initialize());
        }
        return INSTANCE.get();
    }

    private static Optional<XMLGrammarPool> initialize() {
        Thread thread = Thread.currentThread();
        ClassLoader currentClassLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(MuleImplementationLoaderUtils.getMuleImplementationsLoader());
            Optional<XMLGrammarPool> optional = DefaultXmlGrammarPoolManager.doInitialize();
            return optional;
        }
        finally {
            thread.setContextClassLoader(currentClassLoader);
        }
    }

    private static Optional<XMLGrammarPool> doInitialize() {
        XmlSchemaProvider schemaProvider = XmlSchemaProviderFactory.getDefault().create();
        XmlGathererErrorHandler errorHandler = XmlGathererErrorHandlerFactory.getDefault().create();
        XMLEntityResolver entityResolver = XmlEntityResolverFactory.getDefault().create();
        return Optional.of(XmlGrammarPoolBuilder.builder(schemaProvider, errorHandler, entityResolver).build());
    }
}

